/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.ExtendedMath;

public class PSNR
extends TypedAtomicActor {
    public TypedIOPort signal;
    public TypedIOPort distortedSignal;
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);

    public PSNR(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.signal = new TypedIOPort(this, "signal", true, false);
        this.signal.setTypeEquals(BaseType.INT_MATRIX);
        this.distortedSignal = new TypedIOPort(this, "distortedSignal", true, false);
        this.distortedSignal.setTypeEquals(BaseType.INT_MATRIX);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int signalPower = 0;
        int noisePower = 0;
        IntMatrixToken signalToken = (IntMatrixToken)this.signal.get(0);
        IntMatrixToken distortedSignalToken = (IntMatrixToken)this.distortedSignal.get(0);
        int columns = signalToken.getColumnCount();
        int rows = signalToken.getRowCount();
        if (distortedSignalToken.getColumnCount() != columns || distortedSignalToken.getRowCount() != rows) {
            throw new IllegalActionException("Input token dimensions must match!");
        }
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columns; ++i) {
                int element1 = signalToken.getElementAt(j, i);
                int element2 = distortedSignalToken.getElementAt(j, i);
                signalPower += element1 * element1;
                noisePower += (element1 - element2) * (element1 - element2);
            }
        }
        double PSNRValue = 10.0 * ExtendedMath.log10((double)signalPower / (double)noisePower);
        DoubleToken message = new DoubleToken(PSNRValue);
        this.output.send(0, message);
    }
}

