/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class ImageUnpartition
extends Transformer {
    public Parameter imageColumns = new Parameter((NamedObj)this, "imageColumns", new IntToken("176"));
    public Parameter imageRows;
    public Parameter partitionColumns;
    public Parameter partitionRows;
    public Parameter input_tokenConsumptionRate;
    private int[][] _image;
    private int _imageColumns;
    private int _imageRows;
    private int _partitionColumns;
    private int _partitionRows;
    private int _partitionCount;

    public ImageUnpartition(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.imageColumns.setTypeEquals(BaseType.INT);
        this.imageRows = new Parameter((NamedObj)this, "imageRows", new IntToken("144"));
        this.imageRows.setTypeEquals(BaseType.INT);
        this.partitionColumns = new Parameter((NamedObj)this, "partitionColumns", new IntToken("4"));
        this.partitionColumns.setTypeEquals(BaseType.INT);
        this.partitionRows = new Parameter((NamedObj)this, "partitionRows", new IntToken("2"));
        this.partitionRows.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("imageColumns * imageRows / partitionColumns / partitionRows");
        this.input.setTypeEquals(BaseType.INT_MATRIX);
        this.output.setTypeEquals(BaseType.INT_MATRIX);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._imageColumns = ((IntToken)this.imageColumns.getToken()).intValue();
        this._imageRows = ((IntToken)this.imageRows.getToken()).intValue();
        this._partitionColumns = ((IntToken)this.partitionColumns.getToken()).intValue();
        this._partitionRows = ((IntToken)this.partitionRows.getToken()).intValue();
        if (this._imageColumns % this._partitionColumns != 0) {
            throw new IllegalActionException((Nameable)this.imageColumns, this.partitionColumns, "Partition size must evenly divide image size");
        }
        if (this._imageRows % this._partitionRows != 0) {
            throw new IllegalActionException((Nameable)this.imageRows, this.partitionRows, "Partition size must evenly divide image size");
        }
        this._image = new int[this._imageRows][this._imageColumns];
        this._partitionCount = this._imageColumns * this._imageRows / this._partitionColumns / this._partitionRows;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Token[] _partitions = this.input.get(0, this._partitionCount);
        int partitionNumber = 0;
        for (int j = 0; j < this._imageRows; j += this._partitionRows) {
            int i = 0;
            while (i < this._imageColumns) {
                IntMatrixToken partition = (IntMatrixToken)_partitions[partitionNumber];
                if (partition.getRowCount() != this._partitionRows || partition.getColumnCount() != this._partitionColumns) {
                    throw new IllegalActionException("input data must be partitionRows by partitionColumns");
                }
                int[][] part = partition.intMatrix();
                for (int y = 0; y < this._partitionRows; ++y) {
                    System.arraycopy(part[y], 0, this._image[j + y], i, this._partitionColumns);
                }
                i += this._partitionColumns;
                ++partitionNumber;
            }
        }
        this.output.send(0, new IntMatrixToken(this._image));
    }
}

