/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import ptolemy.actor.lib.Source;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class ImageSequence
extends Source {
    public Parameter imageURLTemplate;
    public Parameter imageColumns;
    public Parameter imageRows;
    public Parameter startFrame;
    public Parameter endFrame;
    private int _frameCount;
    private IntMatrixToken[] _images;
    private byte[] _frameBytes;
    private int[][] _frameInts;
    private int _imageColumns;
    private int _imageRows;
    private int _startFrame;
    private int _endFrame;
    private int _frameNumber;

    public ImageSequence(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.INT_MATRIX);
        this.imageURLTemplate = new Parameter((NamedObj)this, "imageURLTemplate", new StringToken("ptolemy/domains/sdf/lib/vq/data/seq/missa/missa***.qcf"));
        this.imageColumns = new Parameter((NamedObj)this, "imageColumns", new IntToken("176"));
        this.imageRows = new Parameter((NamedObj)this, "imageRows", new IntToken("144"));
        this.startFrame = new Parameter((NamedObj)this, "startFrame", new IntToken("0"));
        this.endFrame = new Parameter((NamedObj)this, "endFrame", new IntToken("29"));
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        InputStream source = null;
        String fileRoot = ((StringToken)this.imageURLTemplate.getToken()).stringValue();
        this._startFrame = ((IntToken)this.startFrame.getToken()).intValue();
        this._endFrame = ((IntToken)this.endFrame.getToken()).intValue();
        this._imageColumns = ((IntToken)this.imageColumns.getToken()).intValue();
        this._imageRows = ((IntToken)this.imageRows.getToken()).intValue();
        if (this._images != null) {
            return;
        }
        this._frameCount = this._endFrame - this._startFrame + 1;
        this._images = new IntMatrixToken[this._frameCount];
        this._frameInts = new int[this._imageRows][this._imageColumns];
        this._frameBytes = new byte[this._imageRows * this._imageColumns];
        this._frameNumber = 0;
        while (this._frameNumber < this._frameCount) {
            try {
                byte[] arr = fileRoot.getBytes();
                int i = this._frameNumber + this._startFrame;
                String temporaryFileName = fileRoot;
                int location = temporaryFileName.lastIndexOf(42);
                while (location >= 0) {
                    arr[location] = (byte)(48 + i % 10);
                    i /= 10;
                    temporaryFileName = new String(arr);
                    location = temporaryFileName.lastIndexOf(42);
                }
                String fileName = new String(arr);
                this._debug("file = " + fileName + "\n");
                URL dataurl = this.getClass().getClassLoader().getResource(fileName);
                if (dataurl == null) {
                    throw new FileNotFoundException("Failed to find '" + fileName + "' as " + "a resource");
                }
                source = dataurl.openStream();
                if (this._fullRead(source, this._frameBytes) != this._imageRows * this._imageColumns) {
                    throw new IllegalActionException("Error reading image file!");
                }
                int n = 0;
                for (i = 0; i < this._imageRows; ++i) {
                    int j = 0;
                    while (j < this._imageColumns) {
                        this._frameInts[i][j] = this._frameBytes[n] & 0xFF;
                        ++j;
                        ++n;
                    }
                }
                this._images[this._frameNumber] = new IntMatrixToken(this._frameInts);
            }
            catch (IllegalActionException ex) {
                this._images = null;
                throw new IllegalActionException((Nameable)this, ex, "Failed to initialize");
            }
            catch (Exception ex) {
                this._images = null;
                throw new IllegalActionException((Nameable)this, ex, "Failed to initialize");
            }
            finally {
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException ex) {
                        this._images = null;
                        throw new IllegalActionException((Nameable)this, ex, "Failed to close source");
                    }
                }
            }
            ++this._frameNumber;
        }
        this._frameNumber = 0;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.output.send(0, this._images[this._frameNumber]);
        ++this._frameNumber;
        if (this._frameNumber >= this._frameCount) {
            this._frameNumber = 0;
        }
    }

    private int _fullRead(InputStream s, byte[] b) throws IOException {
        int length = 0;
        int remaining = b.length;
        int bytesRead = 0;
        while (remaining > 0) {
            bytesRead = s.read(b, length, remaining);
            if (bytesRead == -1) {
                throw new IOException("Unexpected EOF:" + s);
            }
            remaining -= bytesRead;
            length += bytesRead;
        }
        return length;
    }
}

