/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib.vq;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class ImagePartition
extends Transformer {
    public Parameter imageColumns = new Parameter((NamedObj)this, "imageColumns", new IntToken("176"));
    public Parameter imageRows;
    public Parameter partitionColumns;
    public Parameter partitionRows;
    public Parameter output_tokenProductionRate;
    private IntMatrixToken[] _partitions;
    private int[][] _part;
    private int _imageColumns;
    private int _imageRows;
    private int _partitionColumns;
    private int _partitionRows;

    public ImagePartition(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.imageColumns.setTypeEquals(BaseType.INT);
        this.imageRows = new Parameter((NamedObj)this, "imageRows", new IntToken("144"));
        this.imageRows.setTypeEquals(BaseType.INT);
        this.partitionColumns = new Parameter((NamedObj)this, "partitionColumns", new IntToken("4"));
        this.partitionColumns.setTypeEquals(BaseType.INT);
        this.partitionRows = new Parameter((NamedObj)this, "partitionRows", new IntToken("2"));
        this.partitionRows.setTypeEquals(BaseType.INT);
        this.output_tokenProductionRate = new Parameter(this.output, "tokenProductionRate");
        this.output_tokenProductionRate.setTypeEquals(BaseType.INT);
        this.output_tokenProductionRate.setExpression("imageColumns * imageRows / partitionColumns / partitionRows");
        this.input.setTypeEquals(BaseType.INT_MATRIX);
        this.output.setTypeEquals(BaseType.INT_MATRIX);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._imageColumns = ((IntToken)this.imageColumns.getToken()).intValue();
        this._imageRows = ((IntToken)this.imageRows.getToken()).intValue();
        this._partitionColumns = ((IntToken)this.partitionColumns.getToken()).intValue();
        this._partitionRows = ((IntToken)this.partitionRows.getToken()).intValue();
        if (this._imageColumns % this._partitionColumns != 0) {
            throw new IllegalActionException((Nameable)this.imageColumns, this.partitionColumns, "Partition size must evenly divide image size");
        }
        if (this._imageRows % this._partitionRows != 0) {
            throw new IllegalActionException((Nameable)this.imageRows, this.partitionRows, "Partition size must evenly divide image size");
        }
        this._part = new int[this._partitionRows][this._partitionColumns];
        int partitionCount = this._imageColumns * this._imageRows / this._partitionColumns / this._partitionRows;
        this._partitions = new IntMatrixToken[partitionCount];
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        IntMatrixToken message = (IntMatrixToken)this.input.get(0);
        if (message.getRowCount() != this._imageRows || message.getColumnCount() != this._imageColumns) {
            throw new IllegalActionException("Input data must be imageRows by imageColumns");
        }
        int[][] image = message.intMatrix();
        int partitionNumber = 0;
        for (int j = 0; j < this._imageRows; j += this._partitionRows) {
            int i = 0;
            while (i < this._imageColumns) {
                for (int y = 0; y < this._partitionRows; ++y) {
                    System.arraycopy(image[j + y], i, this._part[y], 0, this._partitionColumns);
                }
                this._partitions[partitionNumber] = new IntMatrixToken(this._part);
                i += this._partitionColumns;
                ++partitionNumber;
            }
        }
        this.output.send(0, this._partitions, this._partitions.length);
    }
}

