/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class MatrixJoin
extends SDFTransformer {
    public Parameter columns = new Parameter(this, "columns");
    public Parameter rows;

    public MatrixJoin(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.columns.setTypeEquals(BaseType.INT);
        this.columns.setExpression("1");
        this.rows = new Parameter(this, "rows");
        this.rows.setTypeEquals(BaseType.INT);
        this.rows.setExpression("1");
        this.input_tokenConsumptionRate.setExpression("rows * columns");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        int rowsValue;
        if (attribute == this.columns) {
            int columnsValue = ((IntToken)this.columns.getToken()).intValue();
            if (columnsValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid number of columns: " + columnsValue);
            }
        } else if (attribute == this.rows && (rowsValue = ((IntToken)this.rows.getToken()).intValue()) <= 0) {
            throw new IllegalActionException((Nameable)this, "Invalid number of rows: " + rowsValue);
        }
        super.attributeChanged(attribute);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int numberOfColumns = ((IntToken)this.columns.getToken()).intValue();
        int numberOfRows = ((IntToken)this.rows.getToken()).intValue();
        MatrixToken[][] result = new MatrixToken[numberOfRows][numberOfColumns];
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                result[i][j] = (MatrixToken)this.input.get(0);
            }
        }
        this.output.send(0, result[0][0].join(result));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        int columnsValue = ((IntToken)this.columns.getToken()).intValue();
        int rowsValue = ((IntToken)this.rows.getToken()).intValue();
        if (!this.input.hasToken(0, rowsValue * columnsValue)) {
            if (this._debugging) {
                this._debug("Called prefire(), which returns false.");
            }
            return false;
        }
        return super.prefire();
    }
}

