/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.hdf.kernel;

import ptolemy.actor.CompositeActor;
import ptolemy.actor.sched.Scheduler;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.sdf.kernel.CachedSDFScheduler;
import ptolemy.domains.sdf.kernel.SDFDirector;
import ptolemy.domains.sdf.kernel.SDFScheduler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class HDFDirector
extends SDFDirector {
    public Parameter scheduleCacheSize;

    public HDFDirector() throws IllegalActionException, NameDuplicationException {
        this._init();
    }

    public HDFDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public HDFDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.scheduleCacheSize) {
            int cacheSize = ((IntToken)this.scheduleCacheSize.getToken()).intValue();
            ((CachedSDFScheduler)this.getScheduler()).constructCaches(cacheSize);
        }
        super.attributeChanged(attribute);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (!this.isScheduleValid() || this.getContainer() != this.toplevel()) {
            CompositeActor container = (CompositeActor)this.getContainer();
            ChangeRequest request = new ChangeRequest(this, "reschedule"){

                @Override
                protected void _execute() throws KernelException {
                    HDFDirector.this.getScheduler().getSchedule();
                }
            };
            request.setPersistent(false);
            container.requestChange(request);
        }
        return super.postfire();
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        ((CachedSDFScheduler)this.getScheduler()).clearCaches();
        super.preinitialize();
    }

    @Override
    public void setScheduler(Scheduler scheduler) throws IllegalActionException, NameDuplicationException {
        if (!(scheduler instanceof SDFScheduler)) {
            throw new IllegalActionException((Nameable)this, "Scheduler is required to be an instance of SDFScheduler");
        }
        ((SDFScheduler)scheduler).constrainBufferSizes.setExpression("false");
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        int cacheSize = 100;
        this.scheduleCacheSize = new Parameter((NamedObj)this, "scheduleCacheSize", new IntToken(cacheSize));
        try {
            CachedSDFScheduler scheduler = new CachedSDFScheduler(this, this.uniqueName("Scheduler"), cacheSize);
            this.setScheduler(scheduler);
        }
        catch (Exception e) {
            throw new InternalErrorException("Could not create Default Scheduler:\n" + e.getMessage());
        }
        this.allowRateChanges.setToken(BooleanToken.TRUE);
        this.allowRateChanges.setVisibility(Settable.EXPERT);
        this.allowRateChanges.setPersistent(false);
    }
}

