/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.TypedActor;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.FSMDirector;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;

public class ModalDirector
extends FSMDirector {
    protected Set _actorsFired = new HashSet();
    private Set _disabledActors = new HashSet();

    public ModalDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        Transition tr;
        FSMActor controller = this.getController();
        if (this._debugging) {
            this._debug("Firing " + this.getFullName(), " at time " + this.getModelTime());
        }
        controller.readInputs();
        State st = controller.currentState();
        this._enabledTransition = tr = controller.chooseTransition(st.preemptiveTransitionList());
        if (tr != null) {
            TypedActor[] actors;
            if (this._debugging) {
                this._debug("Preemptive transition is enabled.");
            }
            if ((actors = tr.getRefinement()) != null) {
                for (int i2 = 0; i2 < actors.length && !this._stopRequested && !this._disabledActors.contains(actors[i2]); ++i2) {
                    if (this._debugging) {
                        this._debug("Prefire and fire the refinement of the preemptive transition: " + actors[i2].getFullName());
                    }
                    if (!actors[i2].prefire()) continue;
                    actors[i2].fire();
                    this._actorsFired.add(actors[i2]);
                }
            }
            controller.readOutputsFromRefinement();
            return;
        }
        TypedActor[] actors = st.getRefinement();
        if (actors != null) {
            for (i = 0; i < actors.length && !this._stopRequested && !this._disabledActors.contains(actors[i]); ++i) {
                if (this._debugging) {
                    this._debug("Prefire and fire the refinement of the current state: ", actors[i].getFullName());
                }
                if (!actors[i].prefire()) continue;
                actors[i].fire();
                this._actorsFired.add(actors[i]);
            }
        }
        st.setVisited(true);
        controller.readOutputsFromRefinement();
        this._enabledTransition = tr = controller.chooseTransition(st.nonpreemptiveTransitionList());
        if (tr != null) {
            if (this._debugging) {
                this._debug("A transition is enabled.");
            }
            if ((actors = tr.getRefinement()) != null) {
                for (i = 0; i < actors.length && !this._stopRequested && !this._disabledActors.contains(actors[i]); ++i) {
                    if (!actors[i].prefire()) continue;
                    if (this._debugging) {
                        this._debug("Prefire and fire the refinement of the transition: " + actors[i].getFullName());
                    }
                    actors[i].fire();
                    this._actorsFired.add(actors[i]);
                }
                controller.readOutputsFromRefinement();
            }
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        CompositeActor container;
        Director executiveDirector;
        if (this._debugging) {
            this._debug("Postfire called at time: " + this.getModelTime());
        }
        boolean postfireResult = true;
        for (Actor actor : this._actorsFired) {
            if (actor.postfire()) continue;
            this._disabledActors.add(actor);
            postfireResult = false;
        }
        FSMActor controller = this.getController();
        State previousState = controller.currentState();
        postfireResult = controller.postfire() && postfireResult;
        State newState = controller.currentState();
        if (previousState != newState) {
            this._currentLocalReceiverMap = (Map)this._localReceiverMaps.get(controller.currentState());
            if (this._mutationEnabled) {
                ChangeRequest request = new ChangeRequest(this, "increment workspace version to force recalculation of function dependencies"){

                    @Override
                    protected void _execute() throws KernelException {
                        ModalDirector.this.getContainer().workspace().incrVersion();
                    }
                };
                request.setPersistent(false);
                this.getContainer().requestChange(request);
            }
        }
        if (this._enabledTransition != null && (executiveDirector = (container = (CompositeActor)this.getContainer()).getExecutiveDirector()) != null) {
            if (this._debugging) {
                this._debug("ModalDirector: Request refiring by " + executiveDirector.getFullName() + " at " + this.getModelTime());
            }
            executiveDirector.fireAt((Actor)container, this.getModelTime());
        }
        return postfireResult && !this._stopRequested;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._actorsFired.clear();
        return super.prefire();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._actorsFired.clear();
        this._disabledActors.clear();
    }
}

