/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.kernel;

import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.util.Time;
import ptolemy.kernel.util.NamedObj;

public final class DEEvent
implements Comparable {
    private Actor _actor;
    private int _depth;
    private IOPort _ioPort;
    private int _microstep;
    private Time _timestamp;

    public DEEvent(Actor actor, Time timeStamp, int microstep, int depth) {
        this._actor = actor;
        this._ioPort = null;
        this._timestamp = timeStamp;
        this._microstep = microstep;
        this._depth = depth;
    }

    public DEEvent(IOPort ioPort, Time timeStamp, int microstep, int depth) {
        this._actor = (Actor)((Object)ioPort.getContainer());
        this._ioPort = ioPort;
        this._timestamp = timeStamp;
        this._microstep = microstep;
        this._depth = depth;
    }

    public final Actor actor() {
        return this._actor;
    }

    public final int compareTo(Object event) {
        return this.compareTo((DEEvent)event);
    }

    public final int compareTo(DEEvent event) {
        if (this.timeStamp().compareTo(event.timeStamp()) > 0) {
            return 1;
        }
        if (this.timeStamp().compareTo(event.timeStamp()) < 0) {
            return -1;
        }
        if (this.microstep() > event.microstep()) {
            return 1;
        }
        if (this.microstep() < event.microstep()) {
            return -1;
        }
        if (this.depth() > event.depth()) {
            return 1;
        }
        if (this.depth() < event.depth()) {
            return -1;
        }
        return 0;
    }

    public final int depth() {
        return this._depth;
    }

    public final boolean hasTheSameTagAndDepthAs(DEEvent event) {
        return this.hasTheSameTagAs(event) && this.depth() == event.depth();
    }

    public final boolean hasTheSameTagAs(DEEvent event) {
        return this.timeStamp().equals(event.timeStamp()) && this.microstep() == event.microstep();
    }

    public final IOPort ioPort() {
        return this._ioPort;
    }

    public final int microstep() {
        return this._microstep;
    }

    public final Time timeStamp() {
        return this._timestamp;
    }

    public String toString() {
        if (this._ioPort != null) {
            return "DEEvent(time = " + this._timestamp + ", microstep = " + this._microstep + ", depth = " + this._depth + ", dest = " + ((NamedObj)((Object)this._actor)).getFullName() + "." + this._ioPort.getName() + ").";
        }
        return "DEEvent(time = " + this._timestamp + ", microstep = " + this._microstep + ", depth = " + this._depth + ", dest = " + ((NamedObj)((Object)this._actor)).getFullName() + ")" + " -- A PURE EVENT.";
    }

    protected void _updateDepth(int newDepth) {
        if (this._depth >= 0) {
            this._depth = newDepth;
        }
    }
}

