/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.kernel;

import ptolemy.actor.util.CQComparator;
import ptolemy.actor.util.CalendarQueue;
import ptolemy.actor.util.Time;
import ptolemy.domains.de.kernel.DEEvent;
import ptolemy.domains.de.kernel.DEEventQueue;
import ptolemy.kernel.util.DebugListener;

public class DECQEventQueue
implements DEEventQueue {
    private CalendarQueue _cQueue;

    public DECQEventQueue() {
        this._cQueue = new CalendarQueue(new DECQComparator());
    }

    public DECQEventQueue(int minBinCount, int binCountFactor, boolean isAdaptive) {
        this._cQueue = new CalendarQueue(new DECQComparator(), minBinCount, binCountFactor);
        this._cQueue.setAdaptive(isAdaptive);
    }

    @Override
    public void addDebugListener(DebugListener listener) {
        this._cQueue.addDebugListener(listener);
    }

    @Override
    public void clear() {
        this._cQueue.clear();
    }

    @Override
    public final DEEvent get() {
        return (DEEvent)this._cQueue.get();
    }

    @Override
    public final boolean isEmpty() {
        return this._cQueue.isEmpty();
    }

    @Override
    public final synchronized void put(DEEvent event) {
        if (!this._cQueue.includes(event)) {
            this._cQueue.put(event);
            this.notifyAll();
        }
    }

    @Override
    public void removeDebugListener(DebugListener listener) {
        this._cQueue.removeDebugListener(listener);
    }

    @Override
    public final int size() {
        return this._cQueue.size();
    }

    @Override
    public final DEEvent take() {
        return (DEEvent)this._cQueue.take();
    }

    @Override
    public final Object[] toArray() {
        return this._cQueue.toArray();
    }

    public String toString() {
        Object[] array = this.toArray();
        StringBuffer buffer = new StringBuffer("");
        if (array != null) {
            buffer.append("{");
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(array[i]);
            }
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static class DECQComparator
    implements CQComparator {
        private double _binWidth = 1.0;
        private double _zeroReference = 0.0;

        public final int compare(Object object1, Object object2) {
            return ((DEEvent)object1).compareTo((DEEvent)object2);
        }

        @Override
        public final long getVirtualBinNumber(Object event) {
            long value = (long)((double)((DEEvent)event).timeStamp().subtract(this._zeroReference).getLongValue() / this._binWidth);
            if (value != Long.MAX_VALUE) {
                return value;
            }
            return 0x7FFFFFFFFFFFFFFEL;
        }

        @Override
        public void setBinWidth(Object[] entryArray) {
            if (entryArray == null || entryArray.length < 2) {
                this._binWidth = 1.0;
                this._zeroReference = 0.0;
                return;
            }
            double[] diff = new double[entryArray.length - 1];
            Time firstEntryTime = ((DEEvent)entryArray[0]).timeStamp();
            Time lastEntryTime = ((DEEvent)entryArray[entryArray.length - 1]).timeStamp();
            if (firstEntryTime.isInfinite() && firstEntryTime.equals(lastEntryTime)) {
                return;
            }
            double average = lastEntryTime.subtract(firstEntryTime).getDoubleValue();
            double effectiveAverage = 0.0;
            int effectiveSamples = 0;
            if (Double.isInfinite(average /= (double)(entryArray.length - 1))) {
                return;
            }
            for (int i = 0; i < entryArray.length - 1; ++i) {
                diff[i] = ((DEEvent)entryArray[i + 1]).timeStamp().subtract(((DEEvent)entryArray[i]).timeStamp()).getDoubleValue();
                if (!(diff[i] < 2.0 * average)) continue;
                ++effectiveSamples;
                effectiveAverage += diff[i];
            }
            if (effectiveAverage == 0.0 || effectiveSamples == 0) {
                return;
            }
            this._binWidth = (effectiveAverage /= (double)effectiveSamples) * 3.0;
        }

        @Override
        public void setZeroReference(Object zeroReference) {
            this._zeroReference = ((DEEvent)zeroReference).timeStamp().getDoubleValue();
        }
    }
}

