/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.lib.DiscreteClock;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class ContinuousClock
extends DiscreteClock {
    public Parameter defaultValue = new Parameter(this, "defaultValue");

    public ContinuousClock(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.defaultValue.setExpression("0");
        ((Parameter)this.output.getAttribute("signalType")).setToken(new StringToken("CONTINUOUS"));
        ((Parameter)this.trigger.getAttribute("signalType")).setToken(new StringToken("CONTINUOUS"));
    }

    @Override
    public void fire() throws IllegalActionException {
        this._updateTentativeValues();
        CTDirector director = (CTDirector)this.getDirector();
        if (director.isDiscretePhase()) {
            Time currentPhaseTime;
            Time currentTime = director.getModelTime();
            double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
            this._tentativeNextFiringTime = Time.NEGATIVE_INFINITY;
            this._tentativeCycleCountIncrement = 0;
            if (this._tentativeCycleCount > 0) {
                while (this._tentativeCycleStartTime.add(periodValue).compareTo(currentTime) <= 0) {
                    this._tentativeCycleStartTime = this._tentativeCycleStartTime.add(periodValue);
                }
            }
            if (currentTime.compareTo(currentPhaseTime = this._tentativeCycleStartTime.add(this._offsets[this._tentativePhase])) == 0) {
                this._tentativeCurrentValue = this._getValue(this._tentativePhase);
                int cycleLimit = ((IntToken)this.numberOfCycles.getToken()).intValue();
                Time stopTime = this._tentativeStartTime.add((double)cycleLimit * periodValue);
                if (cycleLimit > 0 && currentTime.compareTo(stopTime) >= 0 || this._tentativeDone) {
                    this._tentativeCurrentValue = this.defaultValue.getToken();
                }
                this._tentativeNextFiringTime = this._tentativeCycleStartTime.add(this._offsets[this._tentativePhase]);
                if (this._debugging) {
                    this._debug("next firing is at " + this._tentativeNextFiringTime);
                }
                ++this._tentativePhase;
                if (this._tentativePhase >= this._offsets.length) {
                    this._tentativePhase = 0;
                    this._tentativeCycleStartTime = this._tentativeCycleStartTime.add(periodValue);
                    ++this._tentativeCycleCountIncrement;
                }
                if (this._offsets[this._tentativePhase] >= periodValue) {
                    throw new IllegalActionException((Nameable)this, "Offset number " + this._tentativePhase + " with value " + this._offsets[this._tentativePhase] + " must be strictly less than the " + "period, which is " + periodValue);
                }
            } else if (currentTime.compareTo(currentPhaseTime) < 0) {
                this._tentativeNextFiringTime = currentPhaseTime;
            }
            this._updateStates();
        }
        this.output.send(0, this._currentValue);
        if (this._debugging) {
            this._debug("Output: " + this._currentValue + " at " + this.getDirector().getModelTime() + ".");
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._currentValue = this.defaultValue.getToken();
        this._startTime = Time.POSITIVE_INFINITY;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        if (!(this.getDirector() instanceof CTDirector)) {
            throw new IllegalActionException("ContinuousClock can only be used inside CT domain.");
        }
        super.preinitialize();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        boolean postfireReturns = true;
        if (this.getDirector().getModelTime().compareTo(this.getModelStopTime()) > 0) {
            postfireReturns = false;
        }
        if (this._debugging) {
            this._debug(" --- Postfire returns " + postfireReturns + ".");
        }
        return postfireReturns;
    }
}

