/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel.solver;

import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.domains.ct.kernel.CTBaseIntegrator;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.ODESolver;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Workspace;

public class ExplicitRK45Solver
extends ODESolver {
    private static final String _DEFAULT_NAME = "CT_Runge_Kutta_4_5_Solver";
    private static final double[] _timeInc = new double[]{0.2, 0.3, 0.6, 1.0, 0.875, 1.0};
    private static final double[][] _B = new double[][]{{0.2}, {0.075, 0.225}, {0.3, -0.9, 1.2}, {-0.2037037037037037, 2.5, -2.5925925925925926, 1.2962962962962963}, {0.029495804398148147, 0.341796875, 0.041594328703703706, 0.40034541377314814, 0.061767578125}, {0.09788359788359788, 0.0, 0.4025764895330113, 0.21043771043771045, 0.0, 0.2891022021456804}};
    private static final double[] _E = new double[]{-0.004293774801587311, 0.0, 0.018668586093857853, -0.034155026830808066, -0.019321986607142856, 0.03910220214568039};
    private static final int _order = 5;

    public ExplicitRK45Solver() {
        this((Workspace)null);
    }

    public ExplicitRK45Solver(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_DEFAULT_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException(ex);
        }
    }

    @Override
    public void fireStateTransitionActors() throws IllegalActionException {
        super.fireStateTransitionActors();
        this._incrementRoundCount();
        if (this._getRoundCount() == _timeInc.length) {
            this._resetRoundCount();
            this._setConverged(true);
        }
    }

    @Override
    public final int getAmountOfHistoryInformation() {
        return 0;
    }

    @Override
    public final int getIntegratorAuxVariableCount() {
        return 7;
    }

    @Override
    public void integratorFire(CTBaseIntegrator integrator) throws IllegalActionException {
        double outputValue;
        CTDirector director = (CTDirector)this.getContainer();
        int r = this._getRoundCount();
        double xn = integrator.getState();
        double h = director.getCurrentStepSize();
        double[] k = integrator.getAuxVariables();
        switch (r) {
            case 0: {
                double k0 = integrator.getDerivative();
                integrator.setAuxVariables(0, k0);
                outputValue = xn + h * k0 * _B[0][0];
                break;
            }
            case 1: {
                double k1 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(1, k1);
                outputValue = xn + h * (k[0] * _B[1][0] + k1 * _B[1][1]);
                break;
            }
            case 2: {
                double k2 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(2, k2);
                outputValue = xn + h * (k[0] * _B[2][0] + k[1] * _B[2][1] + k2 * _B[2][2]);
                break;
            }
            case 3: {
                double k3 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(3, k3);
                outputValue = xn + h * (k[0] * _B[3][0] + k[1] * _B[3][1] + k[2] * _B[3][2] + k3 * _B[3][3]);
                break;
            }
            case 4: {
                double k4 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(4, k4);
                outputValue = xn + h * (k[0] * _B[4][0] + k[1] * _B[4][1] + k[2] * _B[4][2] + k[3] * _B[4][3] + k4 * _B[4][4]);
                break;
            }
            case 5: {
                double k5 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(5, k5);
                outputValue = xn + h * (k[0] * _B[5][0] + k[1] * _B[5][1] + k[2] * _B[5][2] + k[3] * _B[5][3] + k[4] * _B[5][4] + k5 * _B[5][5]);
                integrator.setTentativeState(outputValue);
                break;
            }
            default: {
                throw new InvalidStateException(this, "execution sequence out of range.");
            }
        }
        integrator.output.broadcast(new DoubleToken(outputValue));
    }

    @Override
    public boolean integratorIsAccurate(CTBaseIntegrator integrator) {
        try {
            CTDirector director = (CTDirector)this.getContainer();
            double tolerance = director.getErrorTolerance();
            double h = director.getCurrentStepSize();
            double f = ((DoubleToken)integrator.input.get(0)).doubleValue();
            integrator.setTentativeDerivative(f);
            double[] k = integrator.getAuxVariables();
            double error = h * Math.abs(k[0] * _E[0] + k[1] * _E[1] + k[2] * _E[2] + k[3] * _E[3] + k[4] * _E[4] + k[5] * _E[5]);
            integrator.setAuxVariables(6, error);
            if (this._debugging) {
                this._debug("Integrator: " + integrator.getName() + " local truncation error = " + error);
            }
            if (error < tolerance) {
                if (this._debugging) {
                    this._debug("Integrator: " + integrator.getName() + " report a success.");
                }
                return true;
            }
            if (this._debugging) {
                this._debug("Integrator: " + integrator.getName() + " reports a failure.");
            }
            return false;
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(this, (Throwable)e, integrator.getName() + " can't read input.");
        }
    }

    @Override
    public double integratorPredictedStepSize(CTBaseIntegrator integrator) {
        CTDirector director = (CTDirector)this.getContainer();
        double error = integrator.getAuxVariables()[6];
        double h = director.getCurrentStepSize();
        double tolerance = director.getErrorTolerance();
        double newh = 5.0 * h;
        if (error > director.getValueResolution()) {
            newh = h * Math.pow(tolerance / error, 0.2);
        }
        if (this._debugging) {
            this._debug("integrator: " + integrator.getName() + " suggests next step size = " + newh);
        }
        return newh;
    }

    @Override
    protected void _advanceModelTime() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getContainer();
        Time iterationBeginTime = director.getIterationBeginTime();
        double currentStepSize = director.getCurrentStepSize();
        director.setModelTime(iterationBeginTime.add(currentStepSize * _timeInc[this._getRoundCount()]));
    }
}

