/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.io.Serializable;
import ptolemy.actor.IOPort;
import ptolemy.actor.Mailbox;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;

public class CTReceiver
extends Mailbox {
    public static final SignalType CONTINUOUS = new SignalType(){

        public String toString() {
            return "CONTINUOUS";
        }
    };
    public static final SignalType DISCRETE = new SignalType(){

        public String toString() {
            return "DISCRETE";
        }
    };
    public static final SignalType UNKNOWN = new SignalType(){

        public String toString() {
            return "UNKNOWN";
        }
    };
    private SignalType _type = UNKNOWN;

    public CTReceiver() {
    }

    public CTReceiver(IOPort container) throws IllegalActionException {
        super(container);
    }

    @Override
    public Token get() throws NoTokenException {
        if (this._token != null) {
            if (this._type == CONTINUOUS) {
                return this._token;
            }
            if (this._type == DISCRETE) {
                return super.get();
            }
            throw new InvalidStateException(this.getContainer(), "get() is called before the signal type of this port has been set. Bug in CTScheduler?");
        }
        throw new NoTokenException(this.getContainer(), "Attempt to get data from an empty CTReceiver.\nAre you trying to use a discrete signal to drive a continuous port?");
    }

    public SignalType getSignalType() {
        return this._type;
    }

    @Override
    public boolean hasRoom() {
        return true;
    }

    @Override
    public void put(Token token) throws NoRoomException {
        this._token = token;
    }

    @Override
    public void reset() throws IllegalActionException {
        if (this._token != null) {
            this._token = this._token.zero();
        }
    }

    public void setSignalType(SignalType type) {
        this._type = type;
    }

    public static class SignalType
    implements Serializable {
        protected SignalType() {
        }
    }
}

