/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.sched.ScheduleElement;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TotallyOrderedSet;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.BreakpointODESolver;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTEventGenerator;
import ptolemy.domains.ct.kernel.CTExecutionPhase;
import ptolemy.domains.ct.kernel.CTGeneralDirector;
import ptolemy.domains.ct.kernel.CTSchedule;
import ptolemy.domains.ct.kernel.CTStatefulActor;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.domains.ct.kernel.ODESolver;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class CTMultiSolverDirector
extends CTDirector {
    public Parameter breakpointODESolver;
    public Parameter ODESolver;
    protected boolean _initialStatesNotReady;
    private ODESolver _breakpointSolver;
    private String _breakpointSolverClassName;
    private ODESolver _normalSolver;
    private String _normalSolverClassName;
    private static String _solverClasspath = "ptolemy.domains.ct.kernel.solver.";

    public CTMultiSolverDirector() {
    }

    public CTMultiSolverDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public CTMultiSolverDirector(Workspace workspace) {
        super(workspace);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.ODESolver) {
            String newSolverClassName;
            if (this._debugging) {
                this._debug(this.getFullName() + " updating ODE solver...");
            }
            this._normalSolverClassName = (newSolverClassName = ((StringToken)this.ODESolver.getToken()).stringValue().trim()).trim().startsWith(_solverClasspath) ? newSolverClassName : _solverClasspath + newSolverClassName;
            ODESolver newODESolver = this._instantiateODESolver(this._normalSolverClassName);
            if (newODESolver instanceof BreakpointODESolver) {
                throw new IllegalActionException((Nameable)this, this._normalSolverClassName + " can only be used as a breakpoint ODE solver.");
            }
            this._normalSolver = newODESolver;
            this._setCurrentODESolver(this._normalSolver);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public boolean canBeInsideDirector() {
        return false;
    }

    @Override
    public boolean canBeTopLevelDirector() {
        return true;
    }

    public void establishInitialStates() throws IllegalActionException {
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        if (this._debugging) {
            this._debug("Establish the initial states for discrete phase of execution");
            this._debug("  ---> " + this.getName(), ": iterating waveform generators (discrete -> continuous)");
        }
        this._setExecutionPhase(CTExecutionPhase.PREFIRING_DYNAMIC_ACTORS_PHASE);
        this.prefireDynamicActors();
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        this._iterateWaveformGenerators(schedule);
        if (this._debugging) {
            this._debug("  ---> " + this.getName(), ": using a breakpoint solver, find integrator output values and iterate continuous actors to find all continuous-time signal values.");
        }
        this._propagateResolvedStates();
        if (this._debugging) {
            this._debug("  ---> " + this.getName(), ": iterating event generators (continuous -> discrete)");
        }
        this._iterateEventGenerators(schedule);
        if (this._debugging) {
            this._debug("  ---> " + this.getName(), ": iterating purely discrete actors (discrete -> discrete)");
        }
        this._iteratePurelyDiscreteActors(schedule);
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this._debugging && this._verbose) {
            this._debug(this.getName(), " fire: <<< ");
        }
        this._discretePhaseExecution();
        this._markStates();
        if (this.getModelTime().equals(this.getModelStopTime()) || this._stopRequested) {
            return;
        }
        this._continuousPhaseExecution();
        if (this._debugging && this._verbose) {
            this._debug(this.getName(), " end of fire. >>>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventGenerators() throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.FIRING_EVENT_GENERATORS_PHASE);
        try {
            CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
            Iterator eventGenerators = schedule.get(3).actorIterator();
            while (eventGenerators.hasNext() && !this._stopRequested) {
                Actor actor = (Actor)eventGenerators.next();
                if (this._debugging && this._verbose) {
                    this._debug("Prefire event generator: " + actor.getName() + " at time " + this.getModelTime());
                }
                if (!actor.prefire()) {
                    this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
                    throw new IllegalActionException((Nameable)actor, "Actor is not ready to fire. In the CT domain, all event generators should be ready to fire at all times.\nDoes the actor only operate on sequence of tokens?");
                }
                if (this._debugging) {
                    this._debug("Fire event generator : " + actor.getName() + " at time " + this.getModelTime());
                }
                actor.fire();
            }
        }
        finally {
            this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        }
    }

    public ODESolver getBreakpointSolver() {
        return this._breakpointSolver;
    }

    @Override
    public CTGeneralDirector getExecutiveCTGeneralDirector() {
        return null;
    }

    public ODESolver getNormalODESolver() {
        return this._normalSolver;
    }

    @Override
    public String getODESolverClassName() {
        return this._normalSolverClassName;
    }

    public boolean hasCurrentEvent() {
        try {
            CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
            Iterator eventGenerators = schedule.get(3).actorIterator();
            boolean discreteEventsExists = false;
            while (!discreteEventsExists && eventGenerators.hasNext()) {
                CTEventGenerator eventGenerator = (CTEventGenerator)eventGenerators.next();
                if (!eventGenerator.hasCurrentEvent()) continue;
                discreteEventsExists = true;
            }
            return discreteEventsExists |= this._removeCurrentTimeFromBreakpointTable();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        if (this._debugging) {
            this._debug("----- Initializing: " + this.getFullName());
        }
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        if (this._debugging) {
            this._debug(this.getFullName(), " A schedule is computed: ");
            this._debug(schedule.toString());
        }
        super.initialize();
        double initialStepSize = this.getInitialStepSize();
        this.setCurrentStepSize(initialStepSize);
        this.setSuggestedNextStepSize(initialStepSize);
        if (this._debugging) {
            this._debug("Set both current step size and suggested next step size to " + initialStepSize);
        }
        if (this._debugging && this._verbose) {
            this._debug("Set the stop time as a breakpoint: " + this.getModelStopTime());
        }
        this.fireAt((Actor)((Object)this.getContainer()), this.getModelStopTime());
        this._initialStatesNotReady = true;
        if (this._debugging) {
            this._debug("----- End of Initialization of: " + this.getFullName());
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.getModelTime().compareTo(this.getModelStopTime()) > 0) {
            throw new IllegalActionException("Execution can not exceed the stop time.");
        }
        if (this.getModelTime().equals(this.getModelStopTime()) && !this.getBreakPoints().contains(this.getModelTime())) {
            if (this._debugging) {
                this._debug("Postfire returns false at: " + this.getModelTime());
            }
            return false;
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        boolean prefireReturns = super.prefire();
        this._setIterationBeginTime(this.getModelTime());
        return prefireReturns;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (this._debugging) {
            this._debug(this.getFullName(), " instantiating the ODE solver ", this._normalSolverClassName);
        }
        this._normalSolver = this._instantiateODESolver(this._normalSolverClassName);
        if (this._debugging) {
            this._debug(this.getFullName(), "instantiating the breakpoint solver ", this._breakpointSolverClassName);
        }
        this._breakpointSolver = this._instantiateODESolver(this._breakpointSolverClassName);
        this._setCurrentODESolver(this._normalSolver);
    }

    public void produceOutput() throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.PRODUCING_OUTPUTS_PHASE);
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator outputActors = schedule.get(4).actorIterator();
        while (outputActors.hasNext() && !this._stopRequested) {
            Actor actor = (Actor)outputActors.next();
            if (this._debugging && this._verbose) {
                this._debug("Prefire output actor: " + actor.getName() + " at time " + this.getModelTime());
            }
            if (!actor.prefire()) {
                throw new IllegalActionException((Nameable)actor, "Actor is not ready to fire. In the CT domain, all continuous actors should be ready to fire at all times.\nDoes the actor only operate on sequence of tokens?");
            }
            if (this._debugging) {
                this._debug("Fire output actor: " + actor.getName() + " at time " + this.getModelTime());
            }
            actor.fire();
        }
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    public void postfireEventGenerators() throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.POSTFIRING_EVENT_GENERATORS_PHASE);
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator eventGenerators = schedule.get(3).actorIterator();
        boolean postfireReturns = true;
        while (eventGenerators.hasNext() && !this._stopRequested) {
            Actor actor = (Actor)eventGenerators.next();
            postfireReturns = actor.postfire();
            boolean bl = this._postfireReturns = this._postfireReturns && postfireReturns;
            if (!this._debugging) continue;
            this._debug("Postfire event generator : " + actor.getName() + " at time " + this.getModelTime() + ", which returns " + postfireReturns);
        }
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    public void setInitialStatesNotReady() {
        this._initialStatesNotReady = true;
    }

    @Override
    public final void setModelTime(Time newTime) {
        if (this._debugging) {
            this._debug("----- Setting current time to " + newTime);
        }
        this._currentTime = newTime;
    }

    public void updateContinuousStates() throws IllegalActionException {
        if (((BooleanToken)this.synchronizeToRealTime.getToken()).booleanValue()) {
            long timeDifference;
            long realTime = System.currentTimeMillis() - this._timeBase;
            long simulationTime = (long)(this.getModelTime().subtract(this.getModelStartTime()).getDoubleValue() * 1000.0);
            if (this._debugging) {
                this._debug("real time " + realTime + " and simulation time " + simulationTime);
            }
            if ((timeDifference = simulationTime - realTime) > 20L) {
                try {
                    if (this._debugging) {
                        this._debug("Sleep for " + timeDifference + "ms");
                    }
                    Thread.sleep(timeDifference - 20L);
                }
                catch (Exception e) {
                    throw new IllegalActionException((Nameable)this, "Sleep Interrupted" + e.getMessage());
                }
            } else if (this._debugging) {
                this._debug("Warning: " + this.getFullName(), " cannot achieve real-time performance at simulation time " + this.getModelTime());
            }
        }
        this._setExecutionPhase(CTExecutionPhase.UPDATING_CONTINUOUS_STATES_PHASE);
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator actors = schedule.get(0).actorIterator();
        while (actors.hasNext()) {
            Actor actor = (Actor)actors.next();
            if (this._debugging) {
                this._debug("Postfire " + actor);
            }
            boolean postfireReturns = actor.postfire();
            this._postfireReturns = this._postfireReturns && postfireReturns;
        }
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    protected void _continuousPhaseExecution() throws IllegalActionException {
        if (this._debugging) {
            this._debug("\n !!! continuous phase execution at " + this.getModelTime());
        }
        if (this.getSuggestedNextStepSize() == 0.0) {
            return;
        }
        this.setCurrentStepSize(this.getSuggestedNextStepSize());
        this.setCurrentStepSize(this._refinedStepWRTBreakpoints());
        this._setCurrentODESolver(this.getNormalODESolver());
        if (this._debugging) {
            this._debug("execute the system from " + this.getModelTime() + " with a step size " + this.getCurrentStepSize() + " using solver " + this.getCurrentODESolver().getName());
        }
        this._resolveInitialStates();
    }

    protected void _discretePhaseExecution() throws IllegalActionException {
        boolean eventExists;
        this._setDiscretePhase(true);
        this.prefireClear();
        if (this._debugging) {
            this._debug("\n !!! discrete phase execution at " + this.getModelTime());
        }
        this.setCurrentStepSize(0.0);
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        if (this._initialStatesNotReady) {
            this.establishInitialStates();
            this._initialStatesNotReady = false;
        }
        boolean cachedEventStatus = eventExists = this.hasCurrentEvent();
        while (eventExists) {
            if (this._debugging) {
                this._debug("Iterate all actors once in the following order:");
                this._debug("  ---> " + this.getName(), ": iterating event generators (continuous -> discrete)");
            }
            this._iterateEventGenerators(schedule);
            if (this._debugging) {
                this._debug("  ---> " + this.getName(), ": iterating purely discrete actors (discrete -> discrete)");
            }
            this._iteratePurelyDiscreteActors(schedule);
            if (this._debugging) {
                this._debug("  ---> " + this.getName(), ": iterating waveform generators (discrete -> continuous)");
            }
            this._iterateWaveformGenerators(schedule);
            if (this._debugging) {
                this._debug("  ---> " + this.getName(), ": using a breakpoint solver, find integrator output values and iterate continuous actors to find all continuous-time signal values.");
            }
            this._propagateResolvedStates();
            if (this._stopRequested) break;
            if (cachedEventStatus || this.hasCurrentEvent()) {
                cachedEventStatus = this.hasCurrentEvent();
                continue;
            }
            eventExists = false;
        }
        if (this._debugging) {
            this._debug(" >>> The next breakpoint is at " + this.getBreakPoints().first() + ", which is in the future.");
            this._debug(" >>> The fixed point of the current discrete phase of execution is reached.");
        }
        this._setDiscretePhase(false);
    }

    @Override
    protected void _initParameters() {
        super._initParameters();
        try {
            this._normalSolverClassName = "ptolemy.domains.ct.kernel.solver.ExplicitRK23Solver";
            this.ODESolver = new Parameter((NamedObj)this, "ODESolver", new StringToken("ExplicitRK23Solver"));
            this.ODESolver.setTypeEquals(BaseType.STRING);
            this.ODESolver.addChoice(new StringToken("ExplicitRK23Solver").toString());
            this.ODESolver.addChoice(new StringToken("ExplicitRK45Solver").toString());
            this.ODESolver.addChoice(new StringToken("BackwardEulerSolver").toString());
            this.ODESolver.addChoice(new StringToken("ForwardEulerSolver").toString());
            this._breakpointSolverClassName = "ptolemy.domains.ct.kernel.solver.DerivativeResolver";
            this.breakpointODESolver = new Parameter((NamedObj)this, "breakpointODESolver", new StringToken("DerivativeResolver"));
            this.breakpointODESolver.setTypeEquals(BaseType.STRING);
            this.breakpointODESolver.setVisibility(Settable.NOT_EDITABLE);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException("Parameter creation error.");
        }
        catch (NameDuplicationException ex) {
            throw new InvalidStateException(this, "Parameter name duplication.");
        }
    }

    protected boolean _isOutputAccurate() {
        Iterator actors;
        if (this._debugging) {
            this._debug("Check accuracy for output step size control actors:");
        }
        boolean accurate = true;
        try {
            CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
            actors = schedule.get(5).actorIterator();
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException("Can not get schedule.");
        }
        while (actors.hasNext()) {
            CTStepSizeControlActor actor = (CTStepSizeControlActor)actors.next();
            boolean thisAccurate = actor.isOutputAccurate();
            if (this._debugging) {
                this._debug("  Checking output step size control actor: " + ((NamedObj)((Object)actor)).getName() + ", which returns " + thisAccurate);
            }
            accurate = accurate && thisAccurate;
        }
        if (this._debugging) {
            this._debug("Overall output accuracy result: " + accurate);
        }
        return accurate;
    }

    protected boolean _isStateAccurate() {
        Iterator actors;
        if (this._debugging) {
            this._debug("Checking accuracy for state step size control actors:");
        }
        boolean accurate = true;
        try {
            CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
            actors = schedule.get(8).actorIterator();
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException("Can not get schedule.");
        }
        while (actors.hasNext()) {
            CTStepSizeControlActor actor = (CTStepSizeControlActor)actors.next();
            boolean thisAccurate = actor.isStateAccurate();
            if (this._debugging) {
                this._debug("  Checking state step size control actor: " + ((NamedObj)((Object)actor)).getName() + ", which returns " + thisAccurate);
            }
            accurate = accurate && thisAccurate;
        }
        if (this._debugging) {
            this._debug("Overall state accuracy result: " + accurate);
        }
        return accurate;
    }

    protected void _iteratePurelyDiscreteActors(CTSchedule schedule) throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.ITERATING_PURELY_DISCRETE_ACTORS_PHASE);
        this._iterateSchedule(schedule.get(1));
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    protected void _iterateEventGenerators(CTSchedule schedule) throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.GENERATING_EVENTS_PHASE);
        this._iterateSchedule(schedule.get(3));
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    protected void _iterateWaveformGenerators(CTSchedule schedule) throws IllegalActionException {
        this._setExecutionPhase(CTExecutionPhase.GENERATING_WAVEFORMS_PHASE);
        this._iterateSchedule(schedule.get(9));
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    protected double _predictNextStepSize() throws IllegalActionException {
        double predictedStep = this.getCurrentStepSize();
        if (!this.isDiscretePhase()) {
            CTStepSizeControlActor actor;
            predictedStep = 10.0 * this.getCurrentStepSize();
            boolean foundOne = false;
            CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
            Iterator actors = schedule.get(8).actorIterator();
            while (actors.hasNext()) {
                actor = (CTStepSizeControlActor)actors.next();
                predictedStep = Math.min(predictedStep, actor.predictedStepSize());
                foundOne = true;
            }
            actors = schedule.get(5).actorIterator();
            while (actors.hasNext()) {
                actor = (CTStepSizeControlActor)actors.next();
                predictedStep = Math.min(predictedStep, actor.predictedStepSize());
                foundOne = true;
            }
            if (!foundOne) {
                predictedStep = this.getCurrentStepSize() * 5.0;
            }
            if (predictedStep > this.getMaxStepSize()) {
                predictedStep = this.getMaxStepSize();
            }
        }
        return predictedStep;
    }

    protected double _refinedStepWRTOutput() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Refining the current step size w.r.t. all output actors:");
        }
        double timeResolution = this.getTimeResolution();
        double refinedStep = this.getCurrentStepSize();
        boolean triedTheMinimumStepSize = refinedStep == timeResolution;
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator actors = schedule.get(5).actorIterator();
        while (actors.hasNext()) {
            CTStepSizeControlActor actor = (CTStepSizeControlActor)actors.next();
            refinedStep = Math.min(refinedStep, actor.refinedStepSize());
        }
        if (refinedStep < 0.5 * timeResolution) {
            if (triedTheMinimumStepSize) {
                if (this._debugging) {
                    this._debug("The previous step size is the time resolution. The refined step size is less than the time resolution. We can not refine the step size more.");
                }
                throw new IllegalActionException((Nameable)this, "The refined step size is less than the minimum time resolution, at time " + this.getModelTime());
            }
            if (this._debugging) {
                this._debug("The previous step size is bigger than the time resolution. The refined step size is less than the time resolution, try setting the step size to the time resolution.");
            }
            refinedStep = timeResolution;
        }
        if (this._debugging) {
            this._debug(this.getFullName(), "refine step with respect to output to" + refinedStep);
        }
        return refinedStep;
    }

    protected double _refinedStepWRTState() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Refining the current step size w.r.t. all state actors:");
        }
        double refinedStep = this.getCurrentStepSize();
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator actors = schedule.get(8).actorIterator();
        while (actors.hasNext()) {
            CTStepSizeControlActor actor = (CTStepSizeControlActor)actors.next();
            double size = actor.refinedStepSize();
            if (this._debugging) {
                this._debug(((NamedObj)((Object)actor)).getName(), "refines step size to " + size);
            }
            refinedStep = Math.min(refinedStep, size);
        }
        if (refinedStep < 0.5 * this.getMinStepSize()) {
            throw new IllegalActionException((Nameable)this, "Cannot resolve new states even using the minimum step size, at time " + this.getModelTime());
        }
        return refinedStep;
    }

    protected boolean _removeCurrentTimeFromBreakpointTable() throws IllegalActionException {
        boolean currentTimeIsABreakpoint = false;
        TotallyOrderedSet breakPoints = this.getBreakPoints();
        Time now = this.getModelTime();
        if (breakPoints != null && !breakPoints.isEmpty() && breakPoints.contains(now)) {
            currentTimeIsABreakpoint = true;
            Time time = (Time)breakPoints.removeFirst();
            if (time.compareTo(now) < 0) {
                breakPoints.removeAllLessThan(now);
            }
            if (this._debugging) {
                this._debug("Remove " + now + " from the break-point list.");
            }
        }
        return currentTimeIsABreakpoint;
    }

    protected void _propagateResolvedStates() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Propagating the resolved states ...");
        }
        this._setCurrentODESolver(this._breakpointSolver);
        this.getScheduler().getSchedule();
        ODESolver solver = this.getCurrentODESolver();
        if (this._debugging && this._verbose) {
            this._debug("Using breakpoint solver: " + solver.getName() + " to propagate states.");
        }
        this._setExecutionPhase(CTExecutionPhase.PREFIRING_DYNAMIC_ACTORS_PHASE);
        this.prefireDynamicActors();
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        this._setExecutionPhase(CTExecutionPhase.FIRING_STATE_TRANSITION_ACTORS_PHASE);
        solver.fireStateTransitionActors();
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        this._setExecutionPhase(CTExecutionPhase.FIRING_DYNAMIC_ACTORS_PHASE);
        solver.fireDynamicActors();
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        this._setExecutionPhase(CTExecutionPhase.PRODUCING_OUTPUTS_PHASE);
        this.produceOutput();
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
        this._setExecutionPhase(CTExecutionPhase.UPDATING_CONTINUOUS_STATES_PHASE);
        this.updateContinuousStates();
        this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
    }

    protected void _resolveInitialStates() throws IllegalActionException {
        if (this._debugging && this._verbose) {
            this._debug("Resolving the initial states at " + this.getModelTime(), " (current time) plus step size " + this.getCurrentStepSize());
        }
        ODESolver solver = this.getCurrentODESolver();
        if (this._debugging && this._verbose) {
            this._debug("Using ODE solver: " + solver.getName());
        }
        this.prefireClear();
        this.prefireDynamicActors();
        while (!this._stopRequested) {
            CTStatefulActor actor;
            Iterator actors;
            CTSchedule schedule;
            while (!this._stopRequested) {
                solver._resetRoundCount();
                solver._setConverged(false);
                while (!solver._isConverged() && solver.resolveStates()) {
                    this._setExecutionPhase(CTExecutionPhase.FIRING_DYNAMIC_ACTORS_PHASE);
                    solver.fireDynamicActors();
                    this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
                    this._setExecutionPhase(CTExecutionPhase.FIRING_STATE_TRANSITION_ACTORS_PHASE);
                    solver.fireStateTransitionActors();
                    this._setExecutionPhase(CTExecutionPhase.UNKNOWN_PHASE);
                }
                if (solver.resolveStates()) {
                    if (this._debugging && this._verbose) {
                        this._debug("State resolved by solver.");
                    }
                    if (this._isStateAccurate()) break;
                    this.setCurrentStepSize(this._refinedStepWRTState());
                } else {
                    if (this.getCurrentStepSize() < 0.5 * this.getMinStepSize()) {
                        throw new IllegalActionException((Nameable)this, "Cannot resolve new states even using the minimum step size, at time " + this.getModelTime());
                    }
                    this.setCurrentStepSize(0.5 * this.getCurrentStepSize());
                }
                this.setModelTime(this.getIterationBeginTime());
                schedule = (CTSchedule)this.getScheduler().getSchedule();
                actors = schedule.get(7).actorIterator();
                while (actors.hasNext()) {
                    actor = (CTStatefulActor)actors.next();
                    if (this._debugging) {
                        this._debug("Restore states " + actor);
                    }
                    actor.goToMarkedState();
                }
                if (!this._debugging) continue;
                this._debug("Execute the system from " + this.getModelTime() + " with a smaller step size" + this.getCurrentStepSize());
            }
            if (this._stopRequested) break;
            this.produceOutput();
            this.fireEventGenerators();
            if (this._isOutputAccurate()) break;
            this.setModelTime(this.getIterationBeginTime());
            this.setCurrentStepSize(this._refinedStepWRTOutput());
            schedule = (CTSchedule)this.getScheduler().getSchedule();
            actors = schedule.get(7).actorIterator();
            while (actors.hasNext()) {
                actor = (CTStatefulActor)actors.next();
                if (this._debugging) {
                    this._debug("Restore states " + actor);
                }
                actor.goToMarkedState();
            }
            if (!this._debugging || !this._verbose) continue;
            this._debug("Refine the current step size with a smaller one " + this.getCurrentStepSize());
        }
        this.updateContinuousStates();
        this.postfireEventGenerators();
        this.setSuggestedNextStepSize(this._predictNextStepSize());
    }

    private void _iterateSchedule(ScheduleElement schedule) throws IllegalActionException {
        Iterator actors = schedule.actorIterator();
        while (actors.hasNext()) {
            Actor actor = (Actor)actors.next();
            if (this._debugging && this._verbose) {
                this._debug("Prefire actor: " + actor.getName() + " at time " + this.getModelTime());
            }
            if (!actor.prefire()) continue;
            if (this._debugging && this._verbose) {
                this._debug("Fire actor: " + actor.getName() + " at time " + this.getModelTime());
            }
            actor.fire();
            if (this._debugging && this._verbose) {
                this._debug("Postfire actor: " + actor.getName() + " at time " + this.getModelTime());
            }
            this._postfireReturns = actor.postfire() && this._postfireReturns;
        }
    }

    private void _markStates() throws IllegalActionException {
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator actors = schedule.get(7).actorIterator();
        while (actors.hasNext()) {
            CTStatefulActor actor = (CTStatefulActor)actors.next();
            if (this._debugging) {
                this._debug("Save State..." + actor.getName());
            }
            actor.markState();
        }
    }

    private double _refinedStepWRTBreakpoints() {
        double refinedStepSize = this.getCurrentStepSize();
        TotallyOrderedSet breakpoints = this.getBreakPoints();
        if (breakpoints != null && !breakpoints.isEmpty()) {
            Time nextBreakpoint;
            double maximAllowedStepSize;
            if (this._debugging && this._verbose) {
                this._debug("The first breakpoint in the breakpoint list is at " + breakpoints.first());
            }
            if ((maximAllowedStepSize = (nextBreakpoint = (Time)breakpoints.first()).subtract(this.getModelTime()).getDoubleValue()) < refinedStepSize) {
                refinedStepSize = maximAllowedStepSize;
                if (this._debugging) {
                    this._debug("Refining the current step size w.r.t. the next breakpoint to " + maximAllowedStepSize);
                }
            }
        }
        return refinedStepSize;
    }
}

