/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;

public abstract class StructuredType
implements Type {
    protected static final int MAXDEPTHBOUND = 20;

    @Override
    public Type add(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    @Override
    public abstract Object clone() throws CloneNotSupportedException;

    @Override
    public Type divide(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public int depth() {
        return 1;
    }

    @Override
    public int getTypeHash() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    public abstract void initialize(Type var1);

    @Override
    public Type modulo(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    @Override
    public Type multiply(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    @Override
    public Type one() {
        return this;
    }

    @Override
    public Type subtract(Type rightArgumentType) {
        return TypeLattice.leastUpperBound(this, rightArgumentType);
    }

    public void updateType(StructuredType newType) throws IllegalActionException {
        if (newType.depth() >= 20) {
            throw new IllegalActionException("Large type structure detected during type resolution.  The structured type " + newType.toString() + " has depth larger than the bound " + 20 + ".  This may be an indicator of type constraints " + "in a model with no finite solution.");
        }
    }

    @Override
    public Type zero() {
        return this;
    }

    protected abstract int _compare(StructuredType var1);

    protected abstract StructuredType _getRepresentative();

    protected abstract StructuredType _greatestLowerBound(StructuredType var1);

    protected abstract StructuredType _leastUpperBound(StructuredType var1);
}

