/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.HashSet;
import java.util.Set;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.ParserScope;
import ptolemy.kernel.util.IllegalActionException;

public class ParseTreeFreeVariableCollector
extends AbstractParseTreeVisitor {
    protected ParserScope _scope;
    protected Set _set;

    public Set collectFreeVariables(ASTPtRootNode node) throws IllegalActionException {
        return this.collectFreeVariables(node, null);
    }

    public Set collectFreeVariables(ASTPtRootNode node, ParserScope scope) throws IllegalActionException {
        HashSet set;
        this._set = set = new HashSet();
        this._scope = scope;
        node.visit(this);
        this._scope = null;
        this._set = null;
        return set;
    }

    @Override
    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        node.getExpressionTree().visit(this);
        this._set.removeAll(node.getArgumentNameList());
    }

    @Override
    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            return;
        }
        this._set.add(node.getName());
    }

    @Override
    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    @Override
    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        this._visitAllChildren(node);
    }

    protected boolean _isValidName(String name) throws IllegalActionException {
        if (this._scope != null) {
            try {
                return this._scope.getType(name) != null;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected void _visitAllChildren(ASTPtRootNode node) throws IllegalActionException {
        int numChildren = node.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            this._visitChild(node, i);
        }
    }

    @Override
    protected void _visitChild(ASTPtRootNode node, int i) throws IllegalActionException {
        ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
        child.visit(this);
    }
}

