/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.ShortToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public class IntToken
extends ScalarToken {
    public static final IntToken NIL = new IntToken(Integer.MAX_VALUE);
    public static final IntToken ONE = new IntToken(1);
    public static final IntToken ZERO = new IntToken(0);
    private final int _value;

    public IntToken() {
        this._value = 0;
    }

    public IntToken(int value) {
        this._value = value;
    }

    public IntToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(IntToken.notSupportedNullNilStringMessage("IntToken", init));
        }
        try {
            this._value = Integer.parseInt(init);
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    @Override
    public Complex complexValue() {
        return new Complex(this._value);
    }

    public static IntToken convert(Token token) throws IllegalActionException {
        if (token instanceof IntToken) {
            return (IntToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.INT, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(IntToken.notSupportedIncomparableConversionMessage(token, "int"));
        }
        compare = TypeLattice.compare((Type)BaseType.SHORT, token);
        if (compare == 0 || compare == 1) {
            ShortToken shortToken = ShortToken.convert(token);
            IntToken result = new IntToken(shortToken.intValue());
            if (shortToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(shortToken._unitCategoryExponents)) {
                result._unitCategoryExponents = shortToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(IntToken.notSupportedConversionMessage(token, "int"));
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((IntToken)object).isNil()) {
            return false;
        }
        return ((IntToken)object).intValue() == this._value;
    }

    @Override
    public FixPoint fixValue() {
        return new FixPoint(this._value);
    }

    @Override
    public Type getType() {
        return BaseType.INT;
    }

    public int hashCode() {
        return this._value;
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    @Override
    public ScalarToken leftShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new IntToken(this._value << bits);
    }

    @Override
    public ScalarToken logicalRightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new IntToken(this._value >>> bits);
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public Token one() {
        return ONE;
    }

    @Override
    public ScalarToken rightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new IntToken(this._value >> bits);
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        return Integer.toString(this._value) + unitString;
    }

    @Override
    public Token zero() {
        return ZERO;
    }

    @Override
    protected ScalarToken _absolute() {
        IntToken result = this._value >= 0 ? this : new IntToken(-this._value);
        return result;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        int sum = this._value + ((IntToken)rightArgument).intValue();
        return new IntToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) {
        int sum = this._value & ((IntToken)rightArgument).intValue();
        return new IntToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseNot() {
        IntToken result = new IntToken(~this._value);
        return result;
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) {
        int sum = this._value | ((IntToken)rightArgument).intValue();
        return new IntToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) {
        int sum = this._value ^ ((IntToken)rightArgument).intValue();
        return new IntToken(sum);
    }

    @Override
    protected ScalarToken _divide(ScalarToken rightArgument) {
        int quotient = this._value / ((IntToken)rightArgument).intValue();
        return new IntToken(quotient);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((IntToken)rightArgument).doubleValue();
        if (right > (left = this.doubleValue()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        IntToken convertedArgument = (IntToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.intValue());
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) {
        int remainder = this._value % ((IntToken)rightArgument).intValue();
        return new IntToken(remainder);
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        int product = this._value * ((IntToken)rightArgument).intValue();
        return new IntToken(product);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        int difference = this._value - ((IntToken)rightArgument).intValue();
        return new IntToken(difference);
    }
}

