/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.FixToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.FixPoint;
import ptolemy.math.Precision;
import ptolemy.math.Quantizer;

public class FixMatrixToken
extends MatrixToken {
    private FixPoint[][] _value = null;
    private Precision _precision = null;
    private int _rowCount = 0;
    private int _columnCount = 0;

    public FixMatrixToken() {
        this._rowCount = 1;
        this._columnCount = 1;
        this._precision = new Precision(32, 32);
        this._value = new FixPoint[1][1];
        this._value[0][0] = Quantizer.round(0.0, this._precision);
    }

    public FixMatrixToken(FixPoint[][] value) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("FixMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, null);
    }

    public FixMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof FixMatrixToken)) {
            throw new IllegalActionException("A FixMatrixToken cannot be created from the expression '" + init + "'");
        }
        FixPoint[][] value = ((FixMatrixToken)token).fixMatrix();
        this._initialize(value, null);
    }

    public FixMatrixToken(FixPoint[][] value, Precision precision) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("FixMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, precision);
    }

    public FixMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        if (tokens == null) {
            throw new IllegalActionException("FixMatrixToken: The specified array is null.");
        }
        if (tokens.length != rows * columns) {
            throw new IllegalActionException("FixMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new FixPoint[rows][columns];
        for (int i = 0; i < tokens.length; ++i) {
            Token token = tokens[i];
            if (token instanceof ScalarToken) {
                this._value[i / columns][i % columns] = ((ScalarToken)token).fixValue();
                continue;
            }
            if (token instanceof FixToken) {
                this._value[i / columns][i % columns] = ((FixToken)token).fixValue();
                continue;
            }
            throw new IllegalActionException("FixMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
        }
    }

    public static FixMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof FixMatrixToken) {
            return (FixMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.FIX_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(FixMatrixToken.notSupportedIncomparableConversionMessage(token, "[fix]"));
        }
        throw new IllegalActionException(FixMatrixToken.notSupportedConversionMessage(token, "[fix]"));
    }

    @Override
    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        FixPoint[][] value = this.fixMatrix();
        try {
            FixPoint[][] result = new FixPoint[rowSpan][colSpan];
            for (int i = 0; i < rowSpan; ++i) {
                System.arraycopy(value[rowStart + i], colStart, result[i], 0, colSpan);
            }
            return new FixMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        FixMatrixToken matrixArgument = (FixMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        FixPoint[][] matrix = matrixArgument.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                if (this._value[i][j].equals(matrix[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public FixPoint[][] fixMatrix() {
        FixPoint[][] matrix = new FixPoint[this._rowCount][this._columnCount];
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                matrix[i][j] = this._value[i][j];
            }
        }
        return matrix;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return new FixToken(this._value[row][column]);
    }

    public FixPoint getElementAt(int row, int column) {
        return this._value[row][column];
    }

    @Override
    public Type getElementType() {
        return BaseType.UNSIZED_FIX;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    @Override
    public Type getType() {
        return BaseType.FIX_MATRIX;
    }

    public int hashCode() {
        double code = 0.0;
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                code += this._value[i][j].doubleValue();
            }
        }
        return (int)code;
    }

    @Override
    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        for (int i = 0; i < matrices.length; ++i) {
            rows += matrices[i][0].getRowCount();
        }
        for (int j = 0; j < matrices[0].length; ++j) {
            columns += matrices[0][j].getColumnCount();
        }
        FixPoint[][] tiled = new FixPoint[rows][columns];
        int row = 0;
        for (int i = 0; i < matrices.length; ++i) {
            int column = 0;
            for (int j = 0; j < matrices[i].length; ++j) {
                int columnCount;
                if (!(matrices[i][j] instanceof FixMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i][j].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i][j].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                for (int ii = 0; ii < rowCount; ++ii) {
                    System.arraycopy(matrices[i][j].fixMatrix()[ii], 0, tiled[row + ii], column, columnCount);
                }
                column += matrices[0][j].getColumnCount();
            }
            row += matrices[i][0].getRowCount();
        }
        return new FixMatrixToken(tiled);
    }

    @Override
    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        FixPoint[][] source = this.fixMatrix();
        int row = 0;
        for (int i = 0; i < rows.length; ++i) {
            int column = 0;
            for (int j = 0; j < columns.length; ++j) {
                int columnspan;
                FixPoint[][] contents = new FixPoint[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    for (int ii = 0; ii < rowspan; ++ii) {
                        System.arraycopy(source[row + ii], column, contents[ii], 0, columnspan);
                    }
                }
                column += columns[j];
                try {
                    result[i][j] = new FixMatrixToken(contents, this.getElementAt(0, 0).getPrecision());
                    continue;
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
            }
            row += rows[i];
        }
        return result;
    }

    @Override
    public Token one() {
        FixPoint[][] result = new FixPoint[this._rowCount][this._rowCount];
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._rowCount; ++j) {
                result[i][j] = Quantizer.round(0.0, this._precision);
            }
            result[i][i] = Quantizer.round(1.0, this._precision);
        }
        try {
            return new FixMatrixToken(result);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Unequal precisions!");
        }
    }

    @Override
    public Token oneRight() {
        FixPoint[][] result = new FixPoint[this._columnCount][this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = Quantizer.round(0.0, this._precision);
            }
            result[i][i] = Quantizer.round(0.0, this._precision);
        }
        try {
            return new FixMatrixToken(result);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Unequal precisions!");
        }
    }

    @Override
    public Token zero() {
        FixPoint[][] result = new FixPoint[this._rowCount][this._columnCount];
        FixPoint zero = Quantizer.round(0.0, this._precision);
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = zero;
            }
        }
        try {
            return new FixMatrixToken(result);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Unequal precisions!");
        }
    }

    @Override
    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        FixMatrixToken convertedArgument = (FixMatrixToken)rightArgument;
        FixPoint[][] result = convertedArgument.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = result[i][j].add(this._value[i][j]);
            }
        }
        return new FixMatrixToken(result);
    }

    @Override
    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = result[i][j].add(scalar);
            }
        }
        return new FixMatrixToken(result);
    }

    @Override
    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        FixMatrixToken convertedArgument = (FixMatrixToken)rightArgument;
        if (this._columnCount != convertedArgument._rowCount) {
            throw new IllegalActionException("Matrix dimensions are not compatible. Cannot multiply.");
        }
        FixPoint[][] result = new FixPoint[this._rowCount][convertedArgument._columnCount];
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < convertedArgument._columnCount; ++j) {
                FixPoint sum = this._value[i][0].multiply(convertedArgument._value[0][j]);
                for (int k = 1; k < this._columnCount; ++k) {
                    sum = sum.add(this._value[i][k].multiply(convertedArgument._value[k][j]));
                }
                result[i][j] = sum;
            }
        }
        return new FixMatrixToken(result);
    }

    @Override
    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = result[i][j].multiply(scalar);
            }
        }
        return new FixMatrixToken(result);
    }

    @Override
    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        FixMatrixToken convertedArgument = (FixMatrixToken)rightArgument;
        FixPoint[][] result = convertedArgument.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = result[i][j].subtract(this._value[i][j]);
            }
        }
        return new FixMatrixToken(result);
    }

    @Override
    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = result[i][j].subtract(scalar);
            }
        }
        return new FixMatrixToken(result);
    }

    @Override
    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        FixPoint scalar;
        if (rightArgument instanceof FixMatrixToken) {
            if (((FixMatrixToken)rightArgument).getRowCount() != 1 || ((FixMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((FixMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((FixToken)rightArgument).fixValue();
        }
        FixPoint[][] result = this.fixMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = scalar.subtract(result[i][j]);
            }
        }
        return new FixMatrixToken(result);
    }

    private void _initialize(FixPoint[][] value, Precision precision) throws IllegalActionException {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = new FixPoint[this._rowCount][this._columnCount];
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                this._value[i][j] = value[i][j];
                if (this._value[i][j] == null) {
                    this._value[i][j] = Quantizer.round(0.0, precision);
                }
                if (precision == null) {
                    precision = this._value[i][j].getPrecision();
                }
                if (this._precision != null && !this._precision.equals(precision)) {
                    throw new IllegalActionException("Attempt to create a FixMatrixToken with unequal precisions: " + this._precision + " and " + precision);
                }
                this._precision = precision;
            }
        }
    }
}

