/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public class FIFOQueue
implements Cloneable {
    public static final int INFINITE_CAPACITY = -1;
    private Nameable _container = null;
    private int _queueCapacity = -1;
    private LinkedList _queueList = new LinkedList();
    private int _historyCapacity = 0;
    private LinkedList _historyList = new LinkedList();

    public FIFOQueue() {
    }

    public FIFOQueue(Nameable container) {
        this();
        this._container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FIFOQueue(FIFOQueue model) {
        this();
        FIFOQueue fIFOQueue = model;
        synchronized (fIFOQueue) {
            this._queueList.addAll(model.elementList());
            this._historyList.addAll(model.historyElementList());
        }
    }

    public void clear() {
        this._queueList.clear();
        this._historyList.clear();
    }

    public Object clone() {
        return new FIFOQueue(this);
    }

    public List elementList() {
        return this._queueList;
    }

    public Enumeration elements() {
        return Collections.enumeration(this._queueList);
    }

    public Object get(int offset) throws NoSuchElementException {
        Object resultObject = null;
        try {
            resultObject = offset >= 0 ? this._queueList.get(offset) : this._historyList.get(this.historySize() + offset);
        }
        catch (IndexOutOfBoundsException ex) {
            String str = ".";
            if (this._container != null) {
                str = " contained by " + this._container.getFullName();
            }
            throw new NoSuchElementException("No object at offset " + offset + " in the FIFOQueue" + str);
        }
        return resultObject;
    }

    public int getCapacity() {
        return this._queueCapacity;
    }

    public Nameable getContainer() {
        return this._container;
    }

    public int getHistoryCapacity() {
        return this._historyCapacity;
    }

    public List historyElementList() {
        return this._historyList;
    }

    public Enumeration historyElements() {
        return Collections.enumeration(this._historyList);
    }

    public int historySize() {
        return this._historyList.size();
    }

    public boolean isFull() {
        return this._queueList.size() == this._queueCapacity;
    }

    public boolean put(Object element) {
        if (this._queueCapacity == -1 || this._queueCapacity > this._queueList.size()) {
            this._queueList.addLast(element);
            return true;
        }
        return false;
    }

    public void setCapacity(int capacity) throws IllegalActionException {
        if (capacity < 0 && capacity != -1) {
            throw new IllegalActionException(this._container, "Cannot set queue capacity to " + capacity);
        }
        if (capacity != -1 && this.size() > capacity) {
            throw new IllegalActionException(this._container, "Queue contains more elements than the proposed capacity.");
        }
        this._queueCapacity = capacity;
    }

    public void setContainer(Nameable container) {
        this._container = container;
    }

    public void setHistoryCapacity(int capacity) throws IllegalActionException {
        if (capacity > 0) {
            while (this._historyList.size() > capacity) {
                this._historyList.removeFirst();
            }
        } else if (capacity == 0) {
            this._historyList.clear();
        } else if (capacity != -1) {
            throw new IllegalActionException(this._container, "Cannot set history capacity to " + capacity);
        }
        this._historyCapacity = capacity;
    }

    public int size() {
        return this._queueList.size();
    }

    public Object take() throws NoSuchElementException {
        Object resultObject = null;
        try {
            resultObject = this._queueList.removeFirst();
        }
        catch (NoSuchElementException ex) {
            String str = "";
            if (this._container != null) {
                str = " contained by " + this._container.getFullName();
            }
            throw new NoSuchElementException("The FIFOQueue" + str + " is empty!");
        }
        if (this._historyCapacity != 0) {
            if (this._historyCapacity == this._historyList.size()) {
                this._historyList.removeFirst();
            }
            this._historyList.addLast(resultObject);
        }
        return resultObject;
    }
}

