/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Mailbox;
import ptolemy.actor.process.BoundaryDetector;
import ptolemy.actor.process.ProcessDirector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class MailboxBoundaryReceiver
extends Mailbox
implements ProcessReceiver {
    private BoundaryDetector _boundaryDetector = new BoundaryDetector(this);
    private ProcessDirector _director;
    private Thread _readPending = null;
    private boolean _terminate = false;
    private Thread _writePending = null;

    public MailboxBoundaryReceiver() {
    }

    public MailboxBoundaryReceiver(IOPort container) throws IllegalActionException {
        super(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token get() {
        Workspace workspace = this.getContainer().workspace();
        Token result = null;
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            while (!this._terminate) {
                if (super.hasToken()) {
                    result = super.get();
                    if (this._writePending == null) break;
                    this._director.threadUnblocked(this._writePending, this);
                    this._writePending = null;
                    break;
                }
                try {
                    this._readPending = Thread.currentThread();
                    this._director.threadBlocked(Thread.currentThread(), this);
                    workspace.wait(this._director);
                }
                catch (InterruptedException e) {
                    this._terminate = true;
                }
            }
            if (this._terminate) {
                throw new TerminateProcessException("");
            }
        }
        return result;
    }

    public ProcessDirector getDirector() {
        return this._director;
    }

    @Override
    public boolean isConnectedToBoundary() {
        return this._boundaryDetector.isConnectedToBoundary();
    }

    @Override
    public boolean isConnectedToBoundaryInside() {
        return this._boundaryDetector.isConnectedToBoundaryInside();
    }

    @Override
    public boolean isConnectedToBoundaryOutside() {
        return this._boundaryDetector.isConnectedToBoundaryOutside();
    }

    @Override
    public boolean isConsumerReceiver() {
        return this.isConnectedToBoundary();
    }

    @Override
    public boolean isInsideBoundary() {
        return this._boundaryDetector.isInsideBoundary();
    }

    @Override
    public boolean isOutsideBoundary() {
        return this._boundaryDetector.isOutsideBoundary();
    }

    @Override
    public boolean isProducerReceiver() {
        return this.isOutsideBoundary() || this.isInsideBoundary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadBlocked() {
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            return this._readPending != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWriteBlocked() {
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            return this._writePending != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Token token) {
        ProcessDirector processDirector = this._director;
        synchronized (processDirector) {
            while (!this._terminate) {
                if (super.hasRoom()) {
                    super.put(token);
                    if (this._readPending != null) {
                        this._director.threadUnblocked(this._readPending, this);
                        this._readPending = null;
                    }
                    if (this._writePending == null) break;
                    this._director.threadUnblocked(this._writePending, this);
                    this._writePending = null;
                    break;
                }
                try {
                    this._writePending = Thread.currentThread();
                    this._director.threadBlocked(this._writePending, this);
                    Workspace workspace = this.getContainer().workspace();
                    workspace.wait(this._director);
                }
                catch (InterruptedException e) {
                    this._terminate = true;
                }
            }
            if (this._terminate) {
                throw new TerminateProcessException("Process terminated.");
            }
        }
    }

    @Override
    public synchronized void requestFinish() {
        this._terminate = true;
        this.notifyAll();
    }

    @Override
    public void reset() {
        if (this._readPending != null) {
            this._director.threadUnblocked(this._readPending, this);
        }
        if (this._writePending != null) {
            this._director.threadUnblocked(this._writePending, this);
        }
        this._terminate = false;
        this._boundaryDetector.reset();
    }

    @Override
    public void setContainer(IOPort port) throws IllegalActionException {
        super.setContainer(port);
        if (port == null) {
            this._director = null;
        } else {
            Actor actor = (Actor)((Object)port.getContainer());
            Director director = port.isInput() ? actor.getExecutiveDirector() : actor.getDirector();
            if (!(director instanceof ProcessDirector)) {
                throw new IllegalActionException((Nameable)port, "Cannot use an instance of PNQueueReceiver since the director is not a PNDirector.");
            }
            this._director = (ProcessDirector)director;
        }
    }
}

