/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.FixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class Slice
extends FixTransformer {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter start;
    public Parameter end;
    public Parameter lsb;

    public Slice(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.FIX);
        this.start = new Parameter(this, "start");
        this.end = new Parameter(this, "end");
        this.lsb = new StringParameter(this, "lsb");
        this.lsb.setExpression("LSB");
        this.lsb.addChoice("LSB");
        this.lsb.addChoice("MSB");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            FixToken in = (FixToken)this.input.get(0);
            int widthValue = in.fixValue().getPrecision().getNumberOfBits();
            int startValue = ((IntToken)this.start.getToken()).intValue();
            int endValue = ((IntToken)this.end.getToken()).intValue() + 1;
            boolean lsbValue = ((StringToken)this.lsb.getToken()).stringValue().equals("LSB");
            int newStartValue = lsbValue ? widthValue - endValue : startValue;
            int newEndValue = lsbValue ? widthValue - startValue : endValue;
            int shiftBits = lsbValue ? startValue : widthValue - endValue;
            char[] mask = new char[widthValue];
            Arrays.fill(mask, '0');
            Arrays.fill(mask, newStartValue, newEndValue, '1');
            BigDecimal value = new BigDecimal(in.fixValue().getUnscaledValue().and(new BigInteger(new String(mask), 2)).shiftRight(shiftBits));
            Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
            if (newEndValue - newStartValue != precision.getNumberOfBits()) {
                throw new IllegalActionException((Nameable)this, "Bit width of " + (newEndValue - newStartValue) + " is not equal to precision " + precision);
            }
            Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
            Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
            FixPoint result = new FixPoint(value, (Quantization)new FixPointQuantization(precision, overflow, rounding));
            this.sendOutput(this.output, 0, new FixToken(result));
        }
    }
}

