/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.Precision;

public class Multiplexor
extends SynchronousFixTransformer {
    public TypedIOPort A = new TypedIOPort(this, "A", true, false);
    public TypedIOPort B;
    public TypedIOPort select;
    private int _channel = 0;

    public Multiplexor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.A.setTypeEquals(BaseType.FIX);
        this.B = new TypedIOPort(this, "B", true, false);
        this.B.setTypeEquals(BaseType.FIX);
        this.select = new TypedIOPort(this, "select", true, false);
        this.select.setTypeEquals(BaseType.FIX);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.select.isKnown() && this.A.isKnown() && this.B.isKnown()) {
            if (this.select.hasToken(0)) {
                FixToken channel = (FixToken)this.select.get(0);
                this._checkFixTokenWidth(channel, 1);
                this._channel = channel.fixValue().getUnscaledValue().intValue();
            }
            Precision outputPrecision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
            FixToken tokenA = null;
            FixToken tokenB = null;
            if (this.A.hasToken(0) && (tokenA = (FixToken)this.A.get(0)).fixValue().getPrecision().getNumberOfBits() != outputPrecision.getNumberOfBits()) {
                throw new IllegalActionException((Nameable)this, "Input A has different width than the output port");
            }
            if (this.B.hasToken(0) && (tokenB = (FixToken)this.B.get(0)).fixValue().getPrecision().getNumberOfBits() != outputPrecision.getNumberOfBits()) {
                throw new IllegalActionException((Nameable)this, "Input B has different width than the output port");
            }
            if (this._channel == 0) {
                this.sendOutput(this.output, 0, tokenA);
            } else {
                this.sendOutput(this.output, 0, tokenB);
            }
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._channel = 0;
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.A, this.output);
        this.removeDependency(this.B, this.output);
        this.removeDependency(this.select, this.output);
    }
}

