/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.FixTransformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.FixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class FixSequence
extends FixTransformer {
    public TypedIOPort enable;
    public Parameter repeat;
    public Parameter values = new Parameter(this, "values");
    public TypedIOPort trigger = null;
    private int _currentIndex;
    private boolean _outputProduced;

    public FixSequence(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.values.setExpression("{1}");
        this.repeat = new Parameter((NamedObj)this, "repeat", new BooleanToken(false));
        this.repeat.setTypeEquals(BaseType.BOOLEAN);
        this.enable = new TypedIOPort(this, "enable", true, false);
        this.enable.setTypeEquals(BaseType.BOOLEAN);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setMultiport(true);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FixSequence newObject = (FixSequence)super.clone(workspace);
        newObject.output.setTypeEquals(BaseType.FIX);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        ArrayToken valuesArray;
        super.fire();
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            this.trigger.get(i);
        }
        if ((this.enable.getWidth() == 0 || this.enable.hasToken(0) && ((BooleanToken)this.enable.get(0)).booleanValue()) && this._currentIndex < (valuesArray = (ArrayToken)this.values.getToken()).length()) {
            Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
            Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
            Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
            FixPoint result = new FixPoint(((ScalarToken)valuesArray.getElement(this._currentIndex)).doubleValue(), (Quantization)new FixPointQuantization(precision, overflow, rounding));
            this.sendOutput(this.output, 0, new FixToken(result));
            this._outputProduced = true;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._currentIndex = 0;
        this._outputProduced = false;
        super.initialize();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this.trigger.numberOfSources() > 0) {
            for (int i = 0; i < this.trigger.getWidth(); ++i) {
                if (!this.trigger.isKnown(i) || !this.trigger.hasToken(i)) continue;
                return super.prefire();
            }
            if (this._debugging) {
                this._debug("Called prefire(), which returns false because the trigger port is connected and has no input.");
            }
            return false;
        }
        return super.prefire();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._outputProduced) {
            this._outputProduced = false;
            ++this._currentIndex;
            ArrayToken valuesArray = (ArrayToken)this.values.getToken();
            if (this._currentIndex >= valuesArray.length()) {
                boolean repeatValue = ((BooleanToken)this.repeat.getToken()).booleanValue();
                this._currentIndex = repeatValue ? 0 : valuesArray.length();
            }
        }
        return super.postfire();
    }
}

