/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.FixPoint;

public class FixCounter
extends SynchronousFixTransformer {
    public TypedIOPort increment = new TypedIOPort(this, "increment", true, false);
    public TypedIOPort decrement;
    private int _count = 0;
    private int _latestCount = 0;
    private boolean _consumed;

    public FixCounter(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.increment.setTypeEquals(BaseType.FIX);
        this.decrement = new TypedIOPort(this, "decrement", true, false);
        this.decrement.setTypeEquals(BaseType.FIX);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.increment.isKnown() && this.decrement.isKnown()) {
            int i;
            this._latestCount = this._count;
            this._consumed = false;
            for (i = 0; i < this.increment.getWidth(); ++i) {
                if (!this.increment.hasToken(i)) continue;
                this.increment.get(i);
                ++this._latestCount;
                this._consumed = true;
            }
            for (i = 0; i < this.decrement.getWidth(); ++i) {
                if (!this.decrement.hasToken(i)) continue;
                this.decrement.get(i);
                --this._latestCount;
                this._consumed = true;
            }
            if (this._consumed) {
                FixPoint result = new FixPoint(this._latestCount);
                FixToken outputToken = new FixToken(result);
                this.sendOutput(this.output, 0, outputToken);
            }
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._count = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._count = this._latestCount;
        return super.postfire();
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.increment, this.output);
        this.removeDependency(this.decrement, this.output);
    }
}

