/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.io.FileOutputStream;
import java.security.Key;
import java.security.PrivateKey;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.security.KeyStoreActor;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class KeyWriter
extends KeyStoreActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;

    public KeyWriter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(KeyToken.KEY);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postfire() throws IllegalActionException {
        if (this.input.hasToken(0)) {
            KeyToken keyToken = (KeyToken)this.input.get(0);
            Key key = keyToken.getValue();
            if (key instanceof PrivateKey) {
                throw new IllegalActionException((Nameable)this, "Key is a PrivateKey, which is not supported because it requires a certificate");
            }
            try {
                this._keyStore.setKeyEntry(this._alias, key, this._keyPassword.toCharArray(), null);
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Failed to set key '" + key + "' to alias '" + this.alias + "'");
            }
            try {
                FileOutputStream keyStoreOutputStream = null;
                try {
                    keyStoreOutputStream = new FileOutputStream(this.fileOrURL.asFile());
                    this._keyStore.store(keyStoreOutputStream, this._storePassword.toCharArray());
                    keyStoreOutputStream.close();
                }
                finally {
                    try {
                        if (keyStoreOutputStream != null) {
                            keyStoreOutputStream.close();
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + this.fileOrURL.asFile());
                        throwable.printStackTrace();
                    }
                }
                this.output.broadcast(BooleanToken.TRUE);
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to store " + this.fileOrURLDescription());
            }
        }
        return super.postfire();
    }
}

