/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class DatagramReader
extends TypedAtomicActor {
    public TypedIOPort returnAddress;
    public TypedIOPort returnSocketNumber;
    public TypedIOPort output;
    public TypedIOPort trigger = null;
    public Parameter localSocketNumber;
    public Parameter actorBufferLength;
    public Parameter platformBufferLength;
    public Parameter setPlatformBufferLength;
    public Parameter overwrite;
    public Parameter blockAwaitingDatagram;
    public Parameter defaultReturnAddress;
    public Parameter defaultReturnSocketNumber;
    public Parameter defaultOutput;
    private Object _syncFireAndThread = new Object();
    private Object _syncDefaultOutputs = new Object();
    private Object _syncBufferLength = new Object();
    private Object _syncSocket = new Object();
    private int _actorBufferLength;
    private boolean _overwrite;
    private boolean _blockAwaitingDatagram;
    private boolean _multiCast = false;
    private String _defaultReturnAddress;
    private int _defaultReturnSocketNumber;
    private Token _defaultOutputToken;
    private DatagramPacket _receivePacket = null;
    private DatagramPacket _broadcastPacket = null;
    private int _receiveAllocated = 0;
    private int _broadcastAllocated = 0;
    private int _packetsAlreadyAwaitingFire = 0;
    private int _ChangeRequestedToPlatformBufferLength;
    private DatagramSocket _socket;
    private MulticastSocket _multicastSocket;
    private SocketReadingThread _socketReadingThread;
    private String _returnAddress;
    private int _returnSocketNumber;
    private Token _outputToken;
    private InetAddress _address = null;
    private boolean _inReceive = false;
    private boolean _fireIsWaiting = false;
    private boolean _stopFire = false;

    public DatagramReader(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.returnAddress = new TypedIOPort(this, "returnAddress");
        this.returnAddress.setTypeEquals(BaseType.STRING);
        this.returnAddress.setOutput(true);
        this.returnSocketNumber = new TypedIOPort(this, "returnSocketNumber");
        this.returnSocketNumber.setTypeEquals(BaseType.INT);
        this.returnSocketNumber.setOutput(true);
        this.output = new TypedIOPort(this, "output");
        this.output.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.output.setOutput(true);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setTypeEquals(BaseType.GENERAL);
        this.trigger.setMultiport(true);
        this.localSocketNumber = new Parameter(this, "localSocketNumber");
        this.localSocketNumber.setTypeEquals(BaseType.INT);
        this.localSocketNumber.setToken(new IntToken(4004));
        this.actorBufferLength = new Parameter(this, "actorBufferLength");
        this.actorBufferLength.setTypeEquals(BaseType.INT);
        this.actorBufferLength.setToken(new IntToken(440));
        this.platformBufferLength = new Parameter(this, "platformBufferLength");
        this.platformBufferLength.setTypeEquals(BaseType.INT);
        this.platformBufferLength.setToken(new IntToken(64));
        this.setPlatformBufferLength = new Parameter((NamedObj)this, "setPlatformBufferLength", new BooleanToken(false));
        this.setPlatformBufferLength.setTypeEquals(BaseType.BOOLEAN);
        this.overwrite = new Parameter((NamedObj)this, "overwrite", new BooleanToken(true));
        this.overwrite.setTypeEquals(BaseType.BOOLEAN);
        this.blockAwaitingDatagram = new Parameter(this, "blockAwaitingDatagram");
        this.blockAwaitingDatagram.setTypeEquals(BaseType.BOOLEAN);
        this.blockAwaitingDatagram.setExpression("true");
        this.defaultReturnAddress = new Parameter(this, "defaultReturnAddress");
        this.defaultReturnAddress.setTypeEquals(BaseType.STRING);
        this.defaultReturnAddress.setToken(new StringToken("localhost"));
        this.defaultReturnSocketNumber = new Parameter(this, "defaultReturnSocketNumber");
        this.defaultReturnSocketNumber.setTypeEquals(BaseType.INT);
        this.defaultReturnSocketNumber.setExpression("0");
        this.defaultOutput = new Parameter(this, "defaultOutput");
        this.defaultOutput.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.defaultOutput.setExpression("{0ub}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.defaultReturnAddress) {
            Object object = this._syncDefaultOutputs;
            synchronized (object) {
                this._defaultReturnAddress = ((StringToken)this.defaultReturnAddress.getToken()).stringValue();
                if (this._defaultReturnAddress.compareTo("224.0.0.1") >= 0 && this._defaultReturnAddress.compareTo("239.255.255.255") <= 0) {
                    this._multiCast = true;
                    try {
                        this._address = InetAddress.getByName(this._defaultReturnAddress);
                    }
                    catch (UnknownHostException ex) {
                        throw new IllegalActionException((Nameable)this, ex, "The default remote address specifies an unknown host");
                    }
                    if (this._multicastSocket != null) {
                        try {
                            this._multicastSocket.joinGroup(this._address);
                        }
                        catch (IOException exp) {
                            throw new IllegalActionException("can't join the multicast group" + exp);
                        }
                    }
                } else {
                    this._multiCast = false;
                    if (this._multicastSocket != null) {
                        try {
                            this._multicastSocket.leaveGroup(this._address);
                        }
                        catch (IOException exp) {
                            throw new IllegalActionException((Nameable)this, exp, "Disconnecting from the multicast group failed.");
                        }
                    }
                }
            }
        }
        if (attribute == this.defaultReturnSocketNumber) {
            Object object = this._syncDefaultOutputs;
            synchronized (object) {
                this._defaultReturnSocketNumber = ((IntToken)this.defaultReturnSocketNumber.getToken()).intValue();
            }
        }
        if (attribute == this.defaultOutput) {
            Object object = this._syncDefaultOutputs;
            synchronized (object) {
                this._defaultOutputToken = this.output.getType().convert(this.defaultOutput.getToken());
            }
        }
        if (attribute == this.overwrite) {
            this._overwrite = ((BooleanToken)this.overwrite.getToken()).booleanValue();
            if (this._overwrite) {
                Object object = this._syncFireAndThread;
                synchronized (object) {
                    this._syncFireAndThread.notifyAll();
                }
            }
        } else if (attribute == this.blockAwaitingDatagram) {
            this._blockAwaitingDatagram = ((BooleanToken)this.blockAwaitingDatagram.getToken()).booleanValue();
            if (!this._blockAwaitingDatagram) {
                Object object = this._syncFireAndThread;
                synchronized (object) {
                    this._syncFireAndThread.notifyAll();
                }
            }
        } else {
            if (attribute == this.localSocketNumber) {
                DatagramReader datagramReader = this;
                synchronized (datagramReader) {
                    if (this._multiCast) {
                        // empty if block
                    }
                    if (this._socket != null || this._multicastSocket != null) {
                        if (this._socketReadingThread == null) {
                            throw new IllegalActionException((Nameable)this, "thread == null");
                        }
                        if (!this._socketReadingThread.isAlive()) {
                            throw new IllegalActionException((Nameable)this, "thread is not Alive");
                        }
                        int newSocketNumber = ((IntToken)this.localSocketNumber.getToken()).intValue();
                        if (this._multicastSocket != null && newSocketNumber != this._multicastSocket.getLocalPort()) {
                            Object object = this._syncSocket;
                            synchronized (object) {
                                if (this._inReceive) {
                                    try {
                                        this._syncSocket.wait(444L);
                                    }
                                    catch (InterruptedException ex) {
                                        throw new IllegalActionException((Nameable)this, ex, "Interrupted while waiting");
                                    }
                                }
                                this._multicastSocket.close();
                                try {
                                    this._multicastSocket = new MulticastSocket(newSocketNumber);
                                }
                                catch (Exception ex) {
                                    throw new InternalErrorException(this, (Throwable)ex, "Couldn't open new socket number " + newSocketNumber);
                                }
                                if (this._address != null) {
                                    try {
                                        this._multicastSocket.joinGroup(this._address);
                                    }
                                    catch (IOException exp) {
                                        throw new IllegalActionException("can't join the multicast group" + exp);
                                    }
                                }
                            }
                        }
                        if (this._socket != null && newSocketNumber != this._socket.getLocalPort()) {
                            Object object = this._syncSocket;
                            synchronized (object) {
                                if (this._inReceive) {
                                    try {
                                        this._syncSocket.wait(444L);
                                    }
                                    catch (InterruptedException ex) {
                                        throw new IllegalActionException((Nameable)this, ex, "Interrupted while waiting");
                                    }
                                }
                                this._socket.close();
                                try {
                                    this._socket = new DatagramSocket(newSocketNumber);
                                }
                                catch (SocketException ex) {
                                    throw new InternalErrorException(this, (Throwable)ex, "Couldn't open new socket number " + newSocketNumber);
                                }
                            }
                        }
                    }
                }
            }
            if (attribute == this.actorBufferLength) {
                Object object = this._syncBufferLength;
                synchronized (object) {
                    this._actorBufferLength = ((IntToken)this.actorBufferLength.getToken()).intValue();
                }
            } else if (attribute == this.platformBufferLength && this._socket != null) {
                Object object = this._syncBufferLength;
                synchronized (object) {
                    ++this._ChangeRequestedToPlatformBufferLength;
                }
            } else {
                super.attributeChanged(attribute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        boolean useDefaultOutput;
        super.fire();
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            this.trigger.get(i);
        }
        Object object = this._syncFireAndThread;
        synchronized (object) {
            int bytesAvailable = 0;
            byte[] dataBytes = new byte[]{};
            while (this._blockAwaitingDatagram && this._packetsAlreadyAwaitingFire == 0) {
                try {
                    this._fireIsWaiting = true;
                    this._syncFireAndThread.wait();
                    this._fireIsWaiting = false;
                }
                catch (InterruptedException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "!!fire()'s wait interrupted!!");
                }
                finally {
                    if (!this._stopFire) continue;
                    this._stopFire = false;
                    if (this._debugging) {
                        this._debug("return due to stopFire");
                    }
                    return;
                }
            }
            if (this._packetsAlreadyAwaitingFire != 0) {
                bytesAvailable = this._broadcastPacket.getLength();
                useDefaultOutput = bytesAvailable <= 0;
                dataBytes = this._broadcastPacket.getData();
                this._returnAddress = this._broadcastPacket.getAddress().getHostAddress();
                this._returnSocketNumber = this._broadcastPacket.getPort();
                --this._packetsAlreadyAwaitingFire;
            } else {
                useDefaultOutput = true;
            }
            if (!useDefaultOutput) {
                Token[] dataTokens = new Token[bytesAvailable];
                for (int j = 0; j < bytesAvailable; ++j) {
                    dataTokens[j] = new UnsignedByteToken(dataBytes[j]);
                }
                this._outputToken = new ArrayToken(BaseType.UNSIGNED_BYTE, dataTokens);
            }
            this._syncFireAndThread.notifyAll();
        }
        if (!useDefaultOutput) {
            this.returnAddress.broadcast(new StringToken(this._returnAddress));
            this.returnSocketNumber.broadcast(new IntToken(this._returnSocketNumber));
            this.output.broadcast(this._outputToken);
        } else if (this._defaultOutputToken == null) {
            if (this._debugging) {
                this._debug("DO NOT Broadcast ANY output (blank default)");
            }
        } else {
            if (this._debugging) {
                this._debug("Broadcast default outputs");
            }
            object = this._syncDefaultOutputs;
            synchronized (object) {
                this.returnAddress.broadcast(new StringToken(this._defaultReturnAddress));
                this.returnSocketNumber.broadcast(new IntToken(this._defaultReturnSocketNumber));
                this.output.broadcast(this._defaultOutputToken);
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._packetsAlreadyAwaitingFire = 0;
        this._defaultReturnAddress = ((StringToken)this.defaultReturnAddress.getToken()).stringValue();
        this._multiCast = this._defaultReturnAddress.compareTo("224.0.0.1") >= 0 && this._defaultReturnAddress.compareTo("239.255.255.255") <= 0;
        int portNumber = ((IntToken)this.localSocketNumber.getToken()).intValue();
        if (portNumber < 0 || portNumber > 65535) {
            throw new IllegalActionException((Nameable)this, this.localSocketNumber + " is outside the required 0..65535 range");
        }
        if (this._debugging) {
            this._debug(this + "portNumber = " + portNumber);
        }
        if (this._multiCast) {
            try {
                if (this._debugging) {
                    this._debug("Trying to create a new multicast socket on port " + portNumber);
                }
                this._multicastSocket = new MulticastSocket(portNumber);
                if (this._debugging) {
                    this._debug("Multicast Socket created successfully!");
                }
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Failed to create a new multicast socket on port " + portNumber);
            }
            String address = ((StringToken)this.defaultReturnAddress.getToken()).stringValue();
            try {
                this._address = InetAddress.getByName(address);
            }
            catch (UnknownHostException ex) {
                throw new IllegalActionException((Nameable)this, ex, "The default remote address specifies an unknown host");
            }
            try {
                this._multicastSocket.joinGroup(this._address);
            }
            catch (IOException exp) {
                throw new IllegalActionException("can't join the multicast group" + exp);
            }
        }
        try {
            if (this._debugging) {
                this._debug("Trying to create a new socket on port " + portNumber);
            }
            this._socket = new DatagramSocket(portNumber);
            if (this._debugging) {
                this._debug("Socket created successfully!");
            }
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to create a new socket on port " + portNumber);
        }
        this._ChangeRequestedToPlatformBufferLength = 1;
        this._socketReadingThread = new SocketReadingThread();
        this._socketReadingThread.start();
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container != this.getContainer()) {
            this.wrapup();
        }
        super.setContainer(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFire() {
        Object object = this._syncFireAndThread;
        synchronized (object) {
            if (this._fireIsWaiting) {
                this._stopFire = true;
                this._syncFireAndThread.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Object object = this._syncFireAndThread;
        synchronized (object) {
            if (this._fireIsWaiting) {
                this._syncFireAndThread.notifyAll();
            }
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (this._socketReadingThread != null) {
            this._socketReadingThread.interrupt();
            this._socketReadingThread = null;
        } else if (this._debugging) {
            this._debug("socketReadingThread null at wrapup!?");
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        } else if (this._multicastSocket != null) {
            this._multicastSocket.close();
            this._multicastSocket = null;
        } else if (this._debugging) {
            this._debug("Socket null at wrapup!?");
        }
    }

    private class SocketReadingThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean fireAtWillBeCalled;
                Object ex3;
                Object object = DatagramReader.this._syncBufferLength;
                synchronized (object) {
                    if (DatagramReader.this._ChangeRequestedToPlatformBufferLength > 0) {
                        DatagramReader.this._ChangeRequestedToPlatformBufferLength = -1;
                        try {
                            if (((BooleanToken)DatagramReader.this.setPlatformBufferLength.getToken()).booleanValue()) {
                                if (DatagramReader.this._multiCast) {
                                    DatagramReader.this._multicastSocket.setReceiveBufferSize(((IntToken)DatagramReader.this.platformBufferLength.getToken()).intValue());
                                } else {
                                    DatagramReader.this._socket.setReceiveBufferSize(((IntToken)DatagramReader.this.platformBufferLength.getToken()).intValue());
                                }
                            }
                        }
                        catch (SocketException ex2) {
                            System.out.println("Socket Ex." + ex2.toString());
                        }
                        catch (IllegalActionException ex3) {
                            System.out.println("getToken or setToken failedon platformBufferSize" + ex3.toString());
                        }
                    }
                }
                object = DatagramReader.this._syncBufferLength;
                synchronized (object) {
                    if (DatagramReader.this._receivePacket == null || DatagramReader.this._receiveAllocated != DatagramReader.this._actorBufferLength) {
                        DatagramReader.this._receivePacket = new DatagramPacket(new byte[DatagramReader.this._actorBufferLength], DatagramReader.this._actorBufferLength);
                        DatagramReader.this._receiveAllocated = DatagramReader.this._actorBufferLength;
                    }
                }
                if (DatagramReader.this._broadcastPacket == null) {
                    object = DatagramReader.this._syncBufferLength;
                    synchronized (object) {
                        DatagramReader.this._broadcastPacket = new DatagramPacket(new byte[DatagramReader.this._actorBufferLength], DatagramReader.this._actorBufferLength);
                        DatagramReader.this._broadcastAllocated = DatagramReader.this._actorBufferLength;
                    }
                }
                object = DatagramReader.this._syncSocket;
                synchronized (object) {
                    DatagramReader.this._inReceive = true;
                }
                while (DatagramReader.this._inReceive) {
                    DatagramReader.this._receivePacket.setLength(DatagramReader.this._actorBufferLength);
                    if (DatagramReader.this._multiCast) {
                        try {
                            DatagramReader.this._multicastSocket.receive(DatagramReader.this._receivePacket);
                            object = DatagramReader.this._syncSocket;
                            synchronized (object) {
                                DatagramReader.this._inReceive = false;
                                DatagramReader.this._syncSocket.notifyAll();
                                continue;
                            }
                        }
                        catch (IOException ex4) {
                            ex3 = DatagramReader.this._syncSocket;
                            synchronized (ex3) {
                                continue;
                            }
                        }
                        catch (NullPointerException ex5) {
                            if (DatagramReader.this._debugging) {
                                DatagramReader.this._debug("--!!--" + (DatagramReader.this._socket == null));
                            }
                            return;
                        }
                    }
                    try {
                        DatagramReader.this._socket.receive(DatagramReader.this._receivePacket);
                        Object ex5 = DatagramReader.this._syncSocket;
                        synchronized (ex5) {
                            DatagramReader.this._inReceive = false;
                            DatagramReader.this._syncSocket.notifyAll();
                        }
                    }
                    catch (IOException ex6) {
                        ex3 = DatagramReader.this._syncSocket;
                        synchronized (ex3) {
                        }
                    }
                    catch (NullPointerException ex7) {
                        if (DatagramReader.this._debugging) {
                            DatagramReader.this._debug("--!!--" + (DatagramReader.this._socket == null));
                        }
                        return;
                    }
                }
                ex3 = DatagramReader.this._syncFireAndThread;
                synchronized (ex3) {
                    while (DatagramReader.this._packetsAlreadyAwaitingFire != 0 && !DatagramReader.this._overwrite) {
                        try {
                            DatagramReader.this._syncFireAndThread.wait();
                        }
                        catch (InterruptedException ex8) {
                            throw new RuntimeException("-interrupted-");
                        }
                    }
                    DatagramPacket tmp = DatagramReader.this._broadcastPacket;
                    DatagramReader.this._broadcastPacket = DatagramReader.this._receivePacket;
                    DatagramReader.this._receivePacket = tmp;
                    int tmpLength = DatagramReader.this._broadcastAllocated;
                    DatagramReader.this._broadcastAllocated = DatagramReader.this._receiveAllocated;
                    DatagramReader.this._receiveAllocated = tmpLength;
                    if (DatagramReader.this._packetsAlreadyAwaitingFire != 0) {
                        fireAtWillBeCalled = false;
                    } else if (DatagramReader.this._fireIsWaiting) {
                        fireAtWillBeCalled = false;
                        DatagramReader.this._syncFireAndThread.notifyAll();
                        DatagramReader.this._packetsAlreadyAwaitingFire++;
                    } else {
                        fireAtWillBeCalled = true;
                        DatagramReader.this._packetsAlreadyAwaitingFire++;
                    }
                }
                if (!fireAtWillBeCalled) continue;
                try {
                    DatagramReader.this.getDirector().fireAtCurrentTime(DatagramReader.this);
                }
                catch (IllegalActionException ex2) {
                    throw new RuntimeException("fireAtCurrentTime() threw an exception", ex2);
                }
            }
        }
    }
}

