/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.logic;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;

public class Comparator
extends TypedAtomicActor {
    public TypedIOPort left;
    public TypedIOPort right;
    public TypedIOPort output;
    public StringAttribute comparison = new StringAttribute(this, "comparison");
    public Parameter tolerance;
    private int _comparison;
    private double _tolerance;
    private static final int _LT = 0;
    private static final int _LE = 1;
    private static final int _GT = 2;
    private static final int _GE = 3;
    private static final int _EQ = 4;

    public Comparator(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.comparison.setExpression(">");
        this.tolerance = new Parameter(this, "tolerance");
        this.tolerance.setExpression("0.0");
        this.left = new TypedIOPort(this, "left", true, false);
        this.right = new TypedIOPort(this, "right", true, false);
        this.output = new TypedIOPort(this, "output", false, true);
        this.left.setTypeEquals(BaseType.DOUBLE);
        this.right.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.BOOLEAN);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"60\" height=\"30\" style=\"fill:white\"/>\n<polyline points=\"-30,-10, -10,-10, -10,0\" style=\"stroke:grey\"/>\n<polyline points=\"-30,10, 10,10, 10,0\" style=\"stroke:grey\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.tolerance) {
            this._tolerance = ((DoubleToken)this.tolerance.getToken()).doubleValue();
            return;
        } else if (attribute == this.comparison) {
            String comparisonName = this.comparison.getExpression().trim();
            if (comparisonName.equals(">")) {
                this._comparison = 2;
                return;
            } else if (comparisonName.equals(">=")) {
                this._comparison = 3;
                return;
            } else if (comparisonName.equals("<")) {
                this._comparison = 0;
                return;
            } else if (comparisonName.equals("<=")) {
                this._comparison = 1;
                return;
            } else {
                if (!comparisonName.equals("==")) throw new IllegalActionException((Nameable)this, "Unrecognized comparison: " + comparisonName);
                this._comparison = 4;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        BooleanToken result = BooleanToken.FALSE;
        double leftIn = ((DoubleToken)this.left.get(0)).doubleValue();
        double rightIn = ((DoubleToken)this.right.get(0)).doubleValue();
        switch (this._comparison) {
            case 2: {
                if (!(leftIn + this._tolerance > rightIn)) break;
                result = BooleanToken.TRUE;
                break;
            }
            case 3: {
                if (!(leftIn + this._tolerance >= rightIn)) break;
                result = BooleanToken.TRUE;
                break;
            }
            case 0: {
                if (!(leftIn < rightIn + this._tolerance)) break;
                result = BooleanToken.TRUE;
                break;
            }
            case 1: {
                if (!(leftIn <= rightIn + this._tolerance)) break;
                result = BooleanToken.TRUE;
                break;
            }
            case 4: {
                if (!(leftIn <= rightIn + this._tolerance) || !(leftIn >= rightIn - this._tolerance)) break;
                result = BooleanToken.TRUE;
                break;
            }
            default: {
                throw new InternalErrorException("Invalid value for _comparison private variable. Comparator actor (" + this.getFullName() + ")" + " on comparison type " + this._comparison);
            }
        }
        this.output.send(0, result);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.left.hasToken(0) || !this.right.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

