/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.jni;

import java.io.Serializable;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class PointerToken
extends Token {
    public static final Type POINTER = new PointerType();
    private int _value;

    public PointerToken() {
    }

    public PointerToken(int pointer) throws IllegalActionException {
        this._value = pointer;
    }

    @Override
    public Type getType() {
        return POINTER;
    }

    public int getValue() {
        return this._value;
    }

    @Override
    public final BooleanToken isEqualTo(Token rightArgument) throws IllegalActionException {
        if (!(rightArgument instanceof PointerToken)) {
            return BooleanToken.FALSE;
        }
        if (this.getValue() != ((PointerToken)rightArgument).getValue()) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    public String toString() {
        return "Memory @" + this.getValue();
    }

    public static class PointerType
    implements Type,
    Serializable {
        private PointerType() {
        }

        @Override
        public Type add(Type rightArgumentType) {
            return this;
        }

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof PointerToken) {
                return token;
            }
            throw new IllegalActionException("Attempt to convert token " + token + " into a Pointer token, which is not possible.");
        }

        @Override
        public Type divide(Type rightArgumentType) {
            return this;
        }

        @Override
        public Class getTokenClass() {
            return PointerToken.class;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isCompatible(Type type) {
            return type == this;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public int getTypeHash() {
            return Integer.MIN_VALUE;
        }

        @Override
        public boolean isInstantiable() {
            return true;
        }

        @Override
        public boolean isSubstitutionInstance(Type type) {
            return this == type;
        }

        @Override
        public Type modulo(Type rightArgumentType) {
            return this;
        }

        @Override
        public Type multiply(Type rightArgumentType) {
            return this;
        }

        @Override
        public Type one() {
            return this;
        }

        @Override
        public Type subtract(Type rightArgumentType) {
            return this;
        }

        @Override
        public String toString() {
            return "Pointer";
        }

        @Override
        public Type zero() {
            return this;
        }
    }
}

