/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.SharedParameter;

public class SoundActor
extends TypedAtomicActor {
    public SharedParameter bytesPerSample;
    public SharedParameter bufferSize;
    public SharedParameter channels;
    public SharedParameter sampleRate = new SharedParameter((NamedObj)this, "sampleRate", SoundActor.class);
    protected int _bytesPerSample;
    protected int _bufferSize;
    protected int _channels;
    private static double _maxSample = 32767.0;
    protected int _sampleRate;
    protected boolean _isExecuting = false;

    public SoundActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.sampleRate.setExpression("8000");
        this.sampleRate.setTypeEquals(BaseType.INT);
        this.bytesPerSample = new SharedParameter((NamedObj)this, "bytesPerSample", SoundActor.class);
        this.bytesPerSample.setExpression("2");
        this.bytesPerSample.setTypeEquals(BaseType.INT);
        this.channels = new SharedParameter((NamedObj)this, "channels", SoundActor.class);
        this.channels.setExpression("1");
        this.channels.setTypeEquals(BaseType.INT);
        this.bufferSize = new SharedParameter((NamedObj)this, "bufferSize", SoundActor.class);
        this.bufferSize.setExpression("1024");
        this.bufferSize.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.bufferSize) {
            this._bufferSize = ((IntToken)this.bufferSize.getToken()).intValue();
        } else if (attribute == this.channels) {
            int channelsValue = ((IntToken)this.channels.getToken()).intValue();
            if (channelsValue < 1) {
                throw new IllegalActionException((Nameable)this, "Unsupported number of channels: " + channelsValue);
            }
            this._channels = channelsValue;
        } else if (attribute == this.sampleRate) {
            this._sampleRate = ((IntToken)this.sampleRate.getToken()).intValue();
        } else if (attribute == this.bytesPerSample) {
            this._bytesPerSample = ((IntToken)this.bytesPerSample.getToken()).intValue();
            _maxSample = Math.pow(2.0, this._bytesPerSample * 8) - 1.0;
        }
        super.attributeChanged(attribute);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._isExecuting = true;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this._isExecuting = false;
    }

    protected void _doubleArrayToByteArray(double[][] doubleArray, byte[] playbackData) throws IllegalArgumentException {
        for (int currSamp = 0; currSamp < doubleArray[0].length; ++currSamp) {
            for (int currChannel = 0; currChannel < this._channels; ++currChannel) {
                double sample = doubleArray[currChannel][currSamp];
                if (sample > 1.0) {
                    sample = 1.0;
                } else if (sample < -1.0) {
                    sample = -1.0;
                }
                int intValue = (int)Math.floor(sample * _maxSample);
                int base = currSamp * this._bytesPerSample * this._channels + this._bytesPerSample * currChannel;
                switch (this._bytesPerSample) {
                    case 4: {
                        playbackData[base + 3] = (byte)intValue;
                        intValue >>>= 8;
                    }
                    case 3: {
                        playbackData[base + 2] = (byte)intValue;
                        intValue >>>= 8;
                    }
                    case 2: {
                        playbackData[base + 1] = (byte)intValue;
                        intValue >>>= 8;
                    }
                    case 1: {
                        playbackData[base] = (byte)intValue;
                    }
                }
            }
        }
    }
}

