/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Const;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;

public class MobileModel
extends TypedCompositeActor {
    public TypedIOPort input;
    public TypedIOPort modelString;
    public TypedIOPort output;
    public Parameter director;
    public Parameter refresh;
    public Parameter connectPorts;
    public Parameter defaultValue;
    private Director _director;
    private String _moml;
    private MoMLParser _parser;
    private boolean _modelChanged = false;

    public MobileModel(Workspace workspace) throws IllegalActionException {
        super(workspace);
        this._init();
    }

    public MobileModel(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        MobileModel newObject = (MobileModel)super.clone(workspace);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Invoking fire");
        }
        if (this.modelString.getWidth() < 1) {
            throw new IllegalActionException(this.getName() + "need to have" + "the modelString port be connected");
        }
        if (this.modelString.hasToken(0)) {
            StringToken str = null;
            try {
                str = (StringToken)this.modelString.get(0);
                this._parser.reset();
                CompositeActor model = (CompositeActor)this._parser.parse(str.stringValue());
                StringWriter writer = new StringWriter();
                try {
                    model.exportMoML(writer, 1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                String modelMoML = writer.toString();
                this._moml = ((BooleanToken)this.connectPorts.getToken()).booleanValue() ? "<group>\n" + modelMoML + "<relation name=\"newR1\" " + "class=\"ptolemy.actor.TypedIORelation\">\n" + "</relation>\n" + "<relation name=\"newR2\" " + "class=\"ptolemy.actor.TypedIORelation\">\n" + "</relation>\n" + "<link port=\"input\" relation=\"newR1\"/>\n" + "<link port=\"" + model.getName() + ".input\" relation=\"newR1\"/>\n" + "<link port=\"" + model.getName() + ".output\" relation=\"newR2\"/>\n" + "<link port=\"output\" relation=\"newR2\"/>\n" + "</group>" : "<group>\n" + modelMoML + "</group>";
            }
            catch (Exception ex) {
                if (this._debugging) {
                    this._debug("Problem parsing " + str.stringValue());
                }
                throw new IllegalActionException((Nameable)this, ex, "Problem parsing " + str.stringValue());
            }
        }
        super.fire();
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (!this._stopRequested && this._moml != null) {
            if (((BooleanToken)this.refresh.getToken()).booleanValue()) {
                String delete = this._requestToRemoveAll(this);
                MoMLChangeRequest removeRequest = new MoMLChangeRequest(this, this, delete, null);
                this.requestChange(removeRequest);
            }
            MoMLChangeRequest request2 = new MoMLChangeRequest(this, this, this._moml, null);
            this.requestChange(request2);
            if (this._debugging) {
                this._debug("issues change request to modify the model");
            }
            this._moml = null;
            this._modelChanged = true;
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Invoking prefire");
        }
        if (this._modelChanged) {
            this._modelChanged = false;
            return true;
        }
        return super.prefire();
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        this._director = null;
        this._createDirector();
        this._moml = null;
        try {
            this._parser = new MoMLParser();
            MoMLParser.setMoMLFilters(BackwardCompatibility.allFilters());
            if (((BooleanToken)this.connectPorts.getToken()).booleanValue()) {
                Const constActor = new Const(this, "Const");
                constActor.value.setExpression(this.defaultValue.getToken().toString());
                this.connect(this.input, constActor.trigger);
                this.connect(constActor.output, this.output);
            }
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "preinitialize() failed");
        }
        super.preinitialize();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        String delete = this._requestToRemoveAll(this);
        MoMLChangeRequest removeRequest = new MoMLChangeRequest(this, this, delete, null);
        this.requestChange(removeRequest);
        super.wrapup();
        if (this._director != null) {
            try {
                this._director.setContainer(null);
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException(ex);
            }
        }
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        for (Attribute attribute : this.attributeList()) {
            attribute.exportMoML(output, depth);
        }
        for (Port port : this.portList()) {
            port.exportMoML(output, depth);
        }
        output.write(this.exportLinks(depth, null));
    }

    private void _createDirector() throws IllegalActionException {
        try {
            String directorName = ((StringToken)this.director.getToken()).stringValue();
            Class<?> directorClass = Class.forName(directorName);
            Class[] argClasses = new Class[]{CompositeEntity.class, String.class};
            Constructor<?> constructor = directorClass.getConstructor(argClasses);
            if (constructor != null) {
                if (this._debugging) {
                    this._debug("find constructor for the specified director");
                }
                Object[] args = new Object[]{this, "new director"};
                this._director = (Director)constructor.newInstance(args);
                if (this._debugging) {
                    this._debug("create a instance of the specified director");
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalActionException("get an illegal action exceptionwhen create director" + ex);
        }
    }

    private void _init() throws IllegalActionException {
        try {
            this.input = new TypedIOPort(this, "input", true, false);
            this.modelString = new TypedIOPort(this, "modelString", true, false);
            this.modelString.setTypeEquals(BaseType.STRING);
            this.defaultValue = new Parameter((NamedObj)this, "defaultValue", new IntToken(0));
            this.output = new TypedIOPort(this, "output", false, true);
            this.output.setTypeAtLeast(this.defaultValue);
            this.refresh = new Parameter((NamedObj)this, "refresh", new BooleanToken(true));
            this.refresh.setTypeEquals(BaseType.BOOLEAN);
            this.connectPorts = new Parameter((NamedObj)this, "connectPorts", new BooleanToken(true));
            this.connectPorts.setTypeEquals(BaseType.BOOLEAN);
            new Director(this, "defaultDirector");
            this.director = new Parameter((NamedObj)this, "director", new StringToken("ptolemy.actor.Director"));
            this.setClassName("ptolemy.actor.lib.hoc.MobileModel");
        }
        catch (NameDuplicationException e) {
            throw new InternalErrorException(e);
        }
    }

    private String _requestToRemoveAll(CompositeActor actor) {
        if (this._debugging) {
            this._debug("create request to remove old model");
        }
        StringBuffer delete = new StringBuffer("<group>");
        for (Entity entity : actor.entityList()) {
            delete.append("<deleteEntity name=\"" + entity.getName() + "\" class=\"" + entity.getClass().getName() + "\"/>");
        }
        for (IORelation relation : actor.relationList()) {
            delete.append("<deleteRelation name=\"" + relation.getName() + "\" class=\"ptolemy.actor.TypedIORelation\"/>");
        }
        delete.append("</group>");
        return delete.toString();
    }
}

