/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Iterator;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.actor.util.DFUtilities;
import ptolemy.data.ArrayToken;
import ptolemy.data.FunctionToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ApplyFunctionOverSequence
extends TypedAtomicActor {
    public PortParameter function;
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    private int _outputRate;
    private int[] _rate;

    public ApplyFunctionOverSequence(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function = new PortParameter(this, "function");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.function.update();
        FunctionToken functionValue = (FunctionToken)this.function.getToken();
        Token[] arguments = new Token[this.inputPortList().size() - 1];
        int i = 0;
        Iterator ports = this.inputPortList().iterator();
        ports.next();
        while (ports.hasNext()) {
            TypedIOPort port = (TypedIOPort)ports.next();
            if (this._rate[i] == -1) {
                arguments[i] = port.get(0);
            } else {
                Token[] tokens = port.get(0, this._rate[i]);
                arguments[i] = new ArrayToken(port.getType(), tokens);
            }
            ++i;
        }
        Token result = functionValue.apply(arguments);
        if (this._outputRate == -1) {
            this.output.broadcast(result);
        } else {
            ArrayToken resultArray = (ArrayToken)result;
            this.output.broadcast(resultArray.arrayValue(), resultArray.length());
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        super.prefire();
        Iterator ports = this.inputPortList().iterator();
        int i = 0;
        ports.next();
        while (ports.hasNext()) {
            TypedIOPort port = (TypedIOPort)ports.next();
            if (!(this._rate[i] == -1 ? !port.hasToken(0) : !port.hasToken(0, this._rate[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        FunctionType type = (FunctionType)this.function.getType();
        if (type.getReturnType() instanceof ArrayType) {
            this.output.setTypeEquals(((ArrayType)type.getReturnType()).getElementType());
            this._outputRate = DFUtilities.getTokenProductionRate(this.output);
        } else {
            this.output.setTypeEquals(type.getReturnType());
            this._outputRate = -1;
        }
        int i = 0;
        this._rate = new int[this.inputPortList().size() - 1];
        Iterator ports = this.inputPortList().iterator();
        ports.next();
        while (ports.hasNext()) {
            TypedIOPort port = (TypedIOPort)ports.next();
            Type portType = type.getArgType(i);
            if (portType instanceof ArrayType) {
                port.setTypeEquals(((ArrayType)portType).getElementType());
                this._rate[i] = DFUtilities.getTokenConsumptionRate(port);
            } else {
                port.setTypeEquals(portType);
                this._rate[i] = -1;
            }
            ++i;
        }
    }
}

