/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.PlotEffigy;
import ptolemy.actor.gui.PlotTableau;
import ptolemy.actor.gui.PlotTableauFrame;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.plotml.PlotMLParser;

public class PlotterBase
extends TypedAtomicActor
implements Configurable,
Placeable {
    public transient PlotBox plot;
    public Parameter fillOnWrapup = new Parameter((NamedObj)this, "fillOnWrapup", new BooleanToken(true));
    public StringAttribute legend;
    protected URL _base;
    protected Container _container;
    protected transient PlotTableauFrame _frame;
    protected SizeAttribute _plotSize;
    protected String _source;
    protected String _text;
    protected WindowPropertiesAttribute _windowProperties;
    private List _configureBases = null;
    private List _configureSources = null;
    private List _configureTexts = null;
    private String _configureSource;

    public PlotterBase(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.fillOnWrapup.setTypeEquals(BaseType.BOOLEAN);
        this.legend = new StringAttribute(this, "legend");
        this._windowProperties = new WindowPropertiesAttribute(this, "_windowProperties");
        this._windowProperties.setPersistent(true);
        this._plotSize = new SizeAttribute(this, "_plotSize");
        this._plotSize.setPersistent(true);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightGrey\"/>\n<rect x=\"-12\" y=\"-12\" width=\"24\" height=\"24\" style=\"fill:white\"/>\n<rect x=\"2\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"8\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<rect x=\"14\" y=\"-18\" width=\"4\" height=\"4\" style=\"fill:grey\"/>\n<polyline points=\"-10,0, -5,-8, 5,8, 10,0\" style=\"stroke:red\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.legend) {
            if (this.plot != null) {
                this.plot.clearLegends();
                String value = this.legend.getExpression();
                if (value != null && !value.trim().equals("")) {
                    StringTokenizer tokenizer = new StringTokenizer(value, ",");
                    int channel = 0;
                    while (tokenizer.hasMoreTokens()) {
                        this.plot.addLegend(channel++, tokenizer.nextToken().trim());
                    }
                }
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        PlotterBase newObject = (PlotterBase)super.clone(workspace);
        newObject.plot = null;
        newObject._container = null;
        newObject._frame = null;
        return newObject;
    }

    @Override
    public void configure(URL base, String source, String text) throws Exception {
        this._base = base;
        this._source = source;
        this._text = text;
        if (this.plot instanceof Plot) {
            PlotMLParser parser = new PlotMLParser((Plot)this.plot);
            if (source != null && !source.trim().equals("")) {
                URL xmlFile = new URL(base, source);
                InputStream stream = xmlFile.openStream();
                parser.parse(base, stream);
                stream.close();
                this._configureSource = source;
            }
            if (text != null && !text.equals("")) {
                String trimmed = text.trim();
                if (trimmed.startsWith("<?") && trimmed.endsWith("?>")) {
                    if ((trimmed = trimmed.substring(2, trimmed.length() - 2).trim()).startsWith("plotml")) {
                        trimmed = trimmed.substring(6).trim();
                        parser.parse(base, trimmed);
                    }
                } else {
                    parser.parse(base, text);
                }
            }
        } else {
            if (this._configureBases == null) {
                this._configureBases = new LinkedList();
                this._configureSources = new LinkedList();
                this._configureTexts = new LinkedList();
            }
            this._configureBases.add(base);
            this._configureSources.add(source);
            this._configureTexts.add(text);
        }
    }

    @Override
    public String getConfigureSource() {
        return this._configureSource;
    }

    @Override
    public String getConfigureText() {
        if (this.plot == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        PrintWriter print = new PrintWriter(writer);
        print.write("\n<plot>\n");
        this.plot.writeFormat(print);
        print.write("</plot>\n");
        return writer.toString();
    }

    @Override
    public void place(Container container) {
        this._container = container;
        if (this._container == null) {
            if (this._frame != null) {
                this._frame.dispose();
            }
            this._frame = null;
            return;
        }
        if (this._container instanceof PlotBox) {
            this.plot = (PlotBox)this._container;
            this.plot.setButtons(true);
        } else {
            if (this.plot == null) {
                this.plot = this._newPlot();
                this.plot.setTitle(this.getName());
            }
            this.plot.setButtons(true);
            this._container.add(this.plot);
            this.plot.setBackground(null);
        }
        this._implementDeferredConfigurations();
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (this.plot != null) {
            this.plot.clear(false);
            this.plot.repaint();
        }
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        NamedObj previousContainer = this.getContainer();
        super.setContainer(container);
        if (container != previousContainer && previousContainer != null) {
            this._remove();
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (((BooleanToken)this.fillOnWrapup.getToken()).booleanValue() && this.plot != null) {
            this.plot.fillPlot();
        }
        super.wrapup();
    }

    @Override
    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        if (this._frame != null) {
            this._windowProperties.recordProperties(this._frame);
        }
        if (this.plot != null) {
            this._plotSize.recordSize(this.plot);
        }
        super._exportMoMLContents(output, depth);
        String header = "<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML 1//EN\"\n\"http://ptolemy.eecs.berkeley.edu/xml/dtd/PlotML_1.dtd\">";
        if (this.plot != null) {
            output.write(PlotterBase._getIndentPrefix(depth) + "<configure>\n<?plotml " + header + "\n<plot>\n");
            PrintWriter print = new PrintWriter(output);
            this.plot.writeFormat(print);
            output.write("</plot>?>\n" + PlotterBase._getIndentPrefix(depth) + "</configure>\n");
        } else if (this._configureSources != null) {
            Iterator sources = this._configureSources.iterator();
            Iterator texts = this._configureTexts.iterator();
            while (sources.hasNext()) {
                String source = (String)sources.next();
                String text = (String)texts.next();
                if (source != null && !source.trim().equals("")) {
                    output.write(PlotterBase._getIndentPrefix(depth) + "<configure source=\"" + source + "\">");
                    if (text != null) {
                        output.write("<![CDATA[\n");
                    }
                } else {
                    output.write(PlotterBase._getIndentPrefix(depth) + "<configure>\n");
                }
                if (text != null) {
                    output.write(text.trim() + "\n");
                    if (source != null && !source.trim().equals("")) {
                        output.write(PlotterBase._getIndentPrefix(depth) + "]]>\n");
                    }
                }
                output.write(PlotterBase._getIndentPrefix(depth) + "</configure>\n");
            }
        }
    }

    protected void _implementDeferredConfigurations() {
        if (this._configureSources != null) {
            Iterator sources = this._configureSources.iterator();
            Iterator texts = this._configureTexts.iterator();
            Iterator bases = this._configureBases.iterator();
            while (sources.hasNext()) {
                URL base = (URL)bases.next();
                String source = (String)sources.next();
                String text = (String)texts.next();
                try {
                    this.configure(base, source, text);
                }
                catch (Exception ex) {
                    this.getManager().notifyListenersOfException(ex);
                }
            }
            this._configureSources = null;
            this._configureTexts = null;
            this._configureBases = null;
        }
        try {
            this.attributeChanged(this.legend);
        }
        catch (IllegalActionException illegalActionException) {
            // empty catch block
        }
    }

    protected PlotBox _newPlot() {
        return new Plot();
    }

    @Override
    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        try {
            ((Configurable)((Object)destination)).configure(this._base, this._source, this._text);
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Propagation failed.");
        }
    }

    private void _remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PlotterBase.this.plot != null) {
                    if (PlotterBase.this._container != null) {
                        PlotterBase.this._container.remove(PlotterBase.this.plot);
                        PlotterBase.this._container.invalidate();
                        PlotterBase.this._container.repaint();
                    } else if (PlotterBase.this._frame != null) {
                        PlotterBase.this._frame.dispose();
                    }
                }
            }
        });
    }

    protected class PlotWindowTableau
    extends PlotTableau {
        public PlotTableauFrame frame;

        public PlotWindowTableau(PlotEffigy container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this.frame = new PlotTableauFrame((Tableau)this, PlotterBase.this.plot, (Placeable)PlotterBase.this);
            this.setFrame(this.frame);
        }
    }
}

