/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.StringToken;
import ptolemy.data.XMLToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class StringToXML
extends Transformer {
    private XMLToken _outToken;

    public StringToXML(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.STRING);
        this.output.setMultiport(true);
        this.output.setTypeEquals(BaseType.XMLTOKEN);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            StringToken in = (StringToken)this.input.get(i);
            try {
                this._outToken = new XMLToken(in.stringValue());
                this.output.broadcast(this._outToken);
                continue;
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Can't construct an XML Token from '" + in + "'");
            }
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            return true;
        }
        return false;
    }
}

