/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class StringToIntArray
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;

    public StringToIntArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.STRING);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(new ArrayType(BaseType.INT));
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        String inputValue = ((StringToken)this.input.get(0)).stringValue();
        byte[] dataBytes = inputValue.getBytes();
        int bytesAvailable = inputValue.length();
        Token[] dataIntTokens = new Token[bytesAvailable];
        for (int j = 0; j < bytesAvailable; ++j) {
            dataIntTokens[j] = new IntToken(dataBytes[j]);
        }
        this.output.send(0, new ArrayToken(BaseType.INT, dataIntTokens));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

