/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.TypeAttribute;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.math.Complex;

public class ViterbiDecoder
extends Transformer {
    public Parameter polynomialArray;
    public Parameter uncodedRate = new Parameter(this, "uncodedRate");
    public Parameter delay;
    public Parameter softDecoding;
    public Parameter trellisDecoding;
    public Parameter constellation;
    private Parameter _inputRate;
    private Parameter _outputRate;
    private TypeAttribute _type;
    private boolean _trellisMode;
    private boolean _softMode;
    private int _mode;
    private double _trueAmp;
    private double _falseAmp;
    private Complex[] _constellation;
    private int _inputNumber;
    private int _maskNumber;
    private int[] _mask;
    private int _maxPolyValue;
    private int _shiftRegLength = 0;
    private transient boolean _inputNumberInvalid = true;
    private transient boolean _depthInvalid = true;
    private int[][][] _truthTable;
    private int _rowNum;
    private int _colNum;
    private int _depth;
    private double[] _distance;
    private double[] _tempDistance;
    private int[][] _path;
    private int[][] _tempPath;
    private int _flag;
    private static final int _HARD = 0;
    private static final int _SOFT = 1;
    private static final int _TRELLIS = 2;

    public ViterbiDecoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.uncodedRate.setTypeEquals(BaseType.INT);
        this.uncodedRate.setExpression("1");
        this.polynomialArray = new Parameter(this, "polynomialArray");
        this.polynomialArray.setTypeEquals(new ArrayType(BaseType.INT));
        this.polynomialArray.setExpression("{05, 07}");
        this.delay = new Parameter(this, "delay");
        this.delay.setTypeEquals(BaseType.INT);
        this.delay.setExpression("10");
        this.softDecoding = new Parameter(this, "softDecoding");
        this.softDecoding.setExpression("false");
        this.softDecoding.setTypeEquals(BaseType.BOOLEAN);
        this.trellisDecoding = new Parameter(this, "trellisDecoding");
        this.trellisDecoding.setExpression("false");
        this.trellisDecoding.setTypeEquals(BaseType.BOOLEAN);
        this.trellisDecoding.setVisibility(Settable.NONE);
        this.constellation = new Parameter(this, "constellation");
        this.constellation.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.constellation.setExpression("{-1.0, 1.0}");
        this._type = new TypeAttribute(this.input, "inputType");
        this._type.setExpression("boolean");
        this._inputRate = new Parameter(this.input, "tokenConsumptionRate");
        this._inputRate.setExpression("1");
        this.output.setTypeEquals(BaseType.BOOLEAN);
        this._outputRate = new Parameter(this.output, "tokenProductionRate");
        this._outputRate.setExpression("1");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.softDecoding || attribute == this.trellisDecoding) {
            this._trellisMode = ((BooleanToken)this.trellisDecoding.getToken()).booleanValue();
            this._softMode = ((BooleanToken)this.softDecoding.getToken()).booleanValue();
            if (this._trellisMode) {
                this._mode = 2;
                this._type.setExpression("complex");
                this.constellation.setTypeEquals(new ArrayType(BaseType.COMPLEX));
            } else if (this._softMode) {
                this._mode = 1;
                this._type.setExpression("double");
                this.constellation.setTypeEquals(new ArrayType(BaseType.DOUBLE));
            } else {
                this._mode = 0;
                this._type.setExpression("boolean");
            }
        } else if (attribute == this.uncodedRate) {
            this._inputNumber = ((IntToken)this.uncodedRate.getToken()).intValue();
            if (this._inputNumber < 1) {
                throw new IllegalActionException((Nameable)this, "inputLength must be non-negative.");
            }
            this._inputNumberInvalid = true;
            this._outputRate.setToken(new IntToken(this._inputNumber));
        } else if (attribute == this.delay) {
            this._depth = ((IntToken)this.delay.getToken()).intValue();
            if (this._depth < 1) {
                throw new IllegalActionException((Nameable)this, "Delay must be a positive integer.");
            }
            this._depthInvalid = true;
        } else if (attribute == this.polynomialArray) {
            ArrayToken maskToken = (ArrayToken)this.polynomialArray.getToken();
            this._maskNumber = maskToken.length();
            this._mask = new int[this._maskNumber];
            this._maxPolyValue = 0;
            for (int i = 0; i < this._maskNumber; ++i) {
                this._mask[i] = ((IntToken)maskToken.getElement(i)).intValue();
                if (this._mask[i] <= 0) {
                    throw new IllegalActionException((Nameable)this, "Polynomial is required to be strictly positive.");
                }
                if (this._mask[i] <= this._maxPolyValue) continue;
                this._maxPolyValue = this._mask[i];
            }
            this._inputNumberInvalid = true;
            boolean trellisMode = ((BooleanToken)this.trellisDecoding.getToken()).booleanValue();
            if (trellisMode) {
                this._inputRate.setToken(new IntToken(1));
            } else {
                this._inputRate.setToken(new IntToken(this._maskNumber));
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        int i2;
        ArrayToken ampToken;
        int inputRate;
        int constellationOrder;
        super.fire();
        if (this._mode == 2) {
            constellationOrder = this._maskNumber;
            inputRate = 1;
        } else {
            constellationOrder = 1;
            inputRate = this._maskNumber;
        }
        if (this._mode == 2) {
            this._constellation = new Complex[1 << constellationOrder];
            ampToken = (ArrayToken)this.constellation.getToken();
            if (ampToken.length() != 1 << constellationOrder) {
                throw new IllegalActionException((Nameable)this, "Invalid amplitudes for soft decoding!");
            }
            for (i2 = 0; i2 < ampToken.length(); ++i2) {
                this._constellation[i2] = ((ComplexToken)ampToken.getElement(i2)).complexValue();
            }
        } else if (this._mode == 1) {
            ampToken = (ArrayToken)this.constellation.getToken();
            if (ampToken.length() != 1 << constellationOrder) {
                throw new IllegalActionException((Nameable)this, "Invalid amplitudes for soft decoding!");
            }
            this._falseAmp = ((DoubleToken)ampToken.getElement(0)).doubleValue();
            this._trueAmp = ((DoubleToken)ampToken.getElement(1)).doubleValue();
        }
        if (this._inputNumberInvalid) {
            if (this._inputNumber >= this._maskNumber) {
                throw new IllegalActionException((Nameable)this, "Output rate should be larger than input rate.");
            }
            this._shiftRegLength = 0;
            int regLength = 1;
            while (regLength <= this._maxPolyValue) {
                regLength <<= 1;
                ++this._shiftRegLength;
            }
            if (this._inputNumber >= this._shiftRegLength) {
                throw new IllegalActionException((Nameable)this, "The highest order of all polynomials is still too low.");
            }
            this._inputNumberInvalid = false;
            this._rowNum = 1 << this._shiftRegLength - this._inputNumber;
            this._colNum = 1 << this._inputNumber;
            this._truthTable = new int[this._rowNum][this._colNum][3];
            this._distance = new double[this._rowNum];
            this._tempDistance = new double[this._rowNum];
            for (i2 = 0; i2 < this._rowNum; ++i2) {
                this._distance[i2] = 0.0;
                this._tempDistance[i2] = 0.0;
            }
            int inputMask = (1 << this._inputNumber) - 1;
            for (int state = 0; state < this._rowNum; ++state) {
                for (int head = 0; head < this._colNum; ++head) {
                    int input;
                    int oldState;
                    int reg = head << this._shiftRegLength - this._inputNumber;
                    int[] parity = this._calculateParity(this._mask, this._maskNumber, reg += state);
                    int outValue = 0;
                    for (int i3 = this._maskNumber - 1; i3 >= 0; --i3) {
                        outValue <<= 1;
                        outValue += parity[i3];
                    }
                    this._truthTable[state][head][0] = outValue;
                    this._truthTable[state][head][1] = oldState = reg >> this._inputNumber;
                    this._truthTable[state][head][2] = input = reg & inputMask;
                }
            }
        }
        if (this._depthInvalid) {
            this._path = new int[this._rowNum][this._depth + 1];
            this._tempPath = new int[this._rowNum][this._depth + 1];
            for (int i4 = 0; i4 < this._rowNum; ++i4) {
                for (int j = 0; j < this._depth; ++j) {
                    this._path[i4][j] = 0;
                    this._tempPath[i4][j] = 0;
                }
            }
            this._depthInvalid = false;
        }
        Token[] inputToken = this.input.get(0, inputRate);
        for (int state = 0; state < this._rowNum; ++state) {
            double minDistance = 0.0;
            int minInput = 0;
            int minState = 0;
            for (int colIndex = 0; colIndex < this._colNum; ++colIndex) {
                int i5;
                Object y;
                double d = 0.0;
                if (this._mode == 2) {
                    y = ((ComplexToken)inputToken[0]).complexValue();
                    d = this._computeTrellisDistance((Complex)y, this._constellation, this._truthTable[state][colIndex][0]);
                } else if (this._mode == 1) {
                    y = new double[inputRate];
                    for (i5 = 0; i5 < inputRate; ++i5) {
                        y[i5] = ((DoubleToken)inputToken[i5]).doubleValue();
                    }
                    d = this._computeSoftDistance((double[])y, this._falseAmp, this._trueAmp, this._truthTable[state][colIndex][0], inputRate);
                } else {
                    y = new boolean[this._maskNumber];
                    for (i5 = 0; i5 < this._maskNumber; ++i5) {
                        y[i5] = ((BooleanToken)inputToken[i5]).booleanValue();
                    }
                    d = this._computeHardDistance((boolean[])y, this._truthTable[state][colIndex][0], this._maskNumber);
                }
                int oldState = this._truthTable[state][colIndex][1];
                d = this._tempDistance[oldState] + d;
                if (colIndex != 0 && !(d < minDistance)) continue;
                minDistance = d;
                minState = oldState;
                minInput = this._truthTable[state][colIndex][2];
            }
            this._distance[state] = minDistance;
            for (i = 0; i < this._flag; ++i) {
                this._path[state][i] = this._tempPath[minState][i];
            }
            this._path[state][this._flag] = minInput;
        }
        if (this._flag < this._depth) {
            Token[] initialOutput = new BooleanToken[this._inputNumber];
            for (int i6 = 0; i6 < this._inputNumber; ++i6) {
                initialOutput[i6] = BooleanToken.FALSE;
            }
            this.output.broadcast(initialOutput, this._inputNumber);
        } else {
            double minD = 0.0;
            int minIndex = 0;
            for (int state = 0; state < this._rowNum; ++state) {
                if (state != 0 && !(this._distance[state] < minD)) continue;
                minD = this._distance[state];
                minIndex = state;
            }
            Token[] decoded = new BooleanToken[this._inputNumber];
            decoded = this._convertToBit(this._path[minIndex][0], this._inputNumber);
            this.output.broadcast(decoded, this._inputNumber);
            for (int state = 0; state < this._rowNum; ++state) {
                for (i = 0; i < this._flag; ++i) {
                    this._path[state][i] = this._path[state][i + 1];
                }
            }
            --this._flag;
        }
        ++this._flag;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._inputNumberInvalid = true;
        this._flag = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        for (int i = 0; i < this._rowNum; ++i) {
            this._tempDistance[i] = this._distance[i];
            for (int j = 0; j < this._flag; ++j) {
                this._tempPath[i][j] = this._path[i][j];
            }
        }
        return super.postfire();
    }

    private int[] _calculateParity(int[] mask, int maskNumber, int reg) {
        int[] parity = new int[maskNumber];
        for (int i = 0; i < maskNumber; ++i) {
            parity[i] = 0;
            for (int masked = mask[i] & reg; masked > 0; masked >>= 1) {
                parity[i] = parity[i] ^ masked & 1;
            }
        }
        return parity;
    }

    private int _computeHardDistance(boolean[] y, int truthValue, int maskNum) {
        int hammingDistance = 0;
        for (int i = 0; i < maskNum; ++i) {
            int truthBit = truthValue & 1;
            truthValue >>= 1;
            hammingDistance += (y[i] ? 1 : 0) ^ truthBit;
        }
        return hammingDistance;
    }

    private double _computeSoftDistance(double[] y, double falseAmp, double trueAmp, int truthValue, int inputRate) throws IllegalActionException {
        double distance = 0.0;
        for (int i = 0; i < inputRate; ++i) {
            int truthBit = truthValue & 1;
            double truthAmp = truthBit == 1 ? trueAmp : falseAmp;
            distance += Math.pow(y[i] - truthAmp, 2.0);
            truthValue >>= 1;
        }
        return distance;
    }

    private double _computeTrellisDistance(Complex y, Complex[] constellation, int truthValue) {
        Complex truthComplex = constellation[truthValue];
        Complex v = truthComplex.subtract(y);
        return v.magnitudeSquared();
    }

    private BooleanToken[] _convertToBit(int integer, int length) {
        BooleanToken[] bit = new BooleanToken[length];
        for (int i = length - 1; i >= 0; --i) {
            bit[i] = (integer & 1) == 1 ? BooleanToken.TRUE : BooleanToken.FALSE;
            integer >>= 1;
        }
        return bit;
    }
}

