/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import java.util.LinkedList;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class LempelZivDecoder
extends Transformer {
    private LinkedList _decodeBook;

    public LempelZivDecoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.INT);
        new Parameter((NamedObj)this.input, "tokenConsumptionRate", new IntToken(2));
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Token[] inputToken = this.input.get(0, 2);
        int oldPhase = ((IntToken)inputToken[0]).intValue();
        int bit = ((IntToken)inputToken[1]).intValue();
        String current = (String)this._decodeBook.get(oldPhase);
        if (bit == 0) {
            current = current + "0";
        } else if (bit == 1) {
            current = current + "1";
        } else {
            throw new IllegalActionException((Nameable)this, "This is not a valid Lempel-Ziv code.");
        }
        this._decodeBook.add(current);
        for (int i = 0; i < current.length(); ++i) {
            if (current.charAt(i) == '0') {
                this.output.send(0, new BooleanToken(false));
                continue;
            }
            this.output.send(0, new BooleanToken(true));
        }
    }

    @Override
    public void initialize() {
        this._decodeBook = new LinkedList();
        this._decodeBook.add("");
    }
}

