/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ptolemy.actor.Director;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.Publisher;
import ptolemy.actor.lib.Subscriber;
import ptolemy.data.Token;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class SubscriptionAggregator
extends Subscriber {
    public StringParameter operation;
    private boolean _addOperation = true;
    private Set _channelDoesNotMatch = new HashSet();
    private Set _channelMatches = new HashSet();
    private Pattern _channelPattern;
    private List _relations = new LinkedList();

    public SubscriptionAggregator(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setMultiport(false);
        this.operation = new StringParameter(this, "operation");
        this.operation.addChoice("add");
        this.operation.addChoice("multiply");
        this.operation.setExpression("add");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.operation) {
            String newValue = this.operation.stringValue();
            this._addOperation = newValue.equals("add");
        } else if (attribute == this.channel) {
            this._channelPattern = Pattern.compile(this.channel.stringValue());
            super.attributeChanged(attribute);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    protected boolean channelMatches(String channelName) {
        if (this._channel != null && channelName != null) {
            Matcher matcher;
            if (this._channelMatches.contains(channelName)) {
                return true;
            }
            if (this._channelDoesNotMatch.contains(channelName)) {
                return false;
            }
            if (this._channelPattern == null) {
                this._channelPattern = Pattern.compile(this._channel);
            }
            if ((matcher = this._channelPattern.matcher(channelName)).matches()) {
                this._channelMatches.add(channelName);
                return true;
            }
            this._channelDoesNotMatch.add(channelName);
        }
        return false;
    }

    @Override
    public void fire() throws IllegalActionException {
        int width;
        if (this._debugging) {
            this._debug("Called fire()");
        }
        if ((width = this.input.getWidth()) == 0) {
            throw new IllegalActionException((Nameable)this, "SubscriptionAggregator has no matching Publisher.");
        }
        Token result = null;
        for (int i = 0; i < width; ++i) {
            if (!this.input.hasToken(i)) continue;
            Token token = this.input.get(i);
            result = result == null ? token : (this._addOperation ? result.add(token) : result.multiply(token));
        }
        this.output.send(0, result);
    }

    @Override
    protected void _updateLinks() throws IllegalActionException {
        if (this._channel == null) {
            return;
        }
        for (Relation relation : this._relations) {
            this.input.unlink(relation);
        }
        this._relations.clear();
        for (Publisher publisher : this._findPublishers()) {
            TypedIORelation relation;
            if (publisher._relation == null && !publisher._updatedLinks) {
                publisher._updateLinks();
            }
            if (!this.input.isLinked(relation = publisher._relation)) {
                this.input.liberalLink(relation);
            }
            this._relations.add(relation);
        }
        Director director = this.getDirector();
        if (director != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        this._updatedLinks = true;
    }

    private List _findPublishers() {
        CompositeEntity container;
        LinkedList result = new LinkedList();
        for (container = (CompositeEntity)this.getContainer(); container != null && !container.isOpaque(); container = (CompositeEntity)container.getContainer()) {
        }
        if (container != null) {
            for (Object actor : container.deepEntityList()) {
                if (!(actor instanceof Publisher) || !this.channelMatches(((Publisher)actor)._channel)) continue;
                result.add(actor);
            }
        }
        return result;
    }
}

