/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;

public class ComputeHistogram
extends TypedAtomicActor {
    public Parameter minimumValue;
    public Parameter maximumValue;
    public Parameter numberOfBins;
    public PortParameter inputCount;
    public Parameter input_tokenConsumptionRate;
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;
    private int[] _bins;
    private double _minimumValue;
    private double _maximumValue;
    private double _binWidth;
    private int _numberOfBins;

    public ComputeHistogram(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(new ArrayType(BaseType.INT));
        this.minimumValue = new Parameter(this, "minimumValue");
        this.minimumValue.setExpression("0.0");
        this.minimumValue.setTypeEquals(BaseType.DOUBLE);
        this.maximumValue = new Parameter(this, "maximumValue");
        this.maximumValue.setExpression("1.0");
        this.maximumValue.setTypeEquals(BaseType.DOUBLE);
        this.numberOfBins = new Parameter(this, "numberOfBins");
        this.numberOfBins.setExpression("10");
        this.numberOfBins.setTypeEquals(BaseType.INT);
        this.inputCount = new PortParameter(this, "inputCount");
        this.inputCount.setExpression("10");
        this.inputCount.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setExpression("inputCount");
        this.input_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.input_tokenConsumptionRate.setPersistent(false);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.minimumValue || attribute == this.maximumValue || attribute == this.numberOfBins) {
            this._minimumValue = ((DoubleToken)this.minimumValue.getToken()).doubleValue();
            this._maximumValue = ((DoubleToken)this.maximumValue.getToken()).doubleValue();
            this._numberOfBins = ((IntToken)this.numberOfBins.getToken()).intValue();
            double width = (this._maximumValue - this._minimumValue) / (double)this._numberOfBins;
            if (width <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Invalid bin width (must be positive): " + width);
            }
            this._binWidth = width;
            this._bins = new int[this._numberOfBins];
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._bins = new int[this._numberOfBins];
        this.inputCount.update();
        int count = ((IntToken)this.inputCount.getToken()).intValue();
        for (int i = 0; i < count; ++i) {
            if (!this.input.hasToken(0)) continue;
            DoubleToken curToken = (DoubleToken)this.input.get(0);
            double curValue = curToken.doubleValue();
            this._addPoint(curValue);
        }
        Token[] values = new Token[this._bins.length];
        for (int i = 0; i < this._bins.length; ++i) {
            values[i] = new IntToken(this._bins[i]);
        }
        this.output.send(0, new ArrayToken(BaseType.INT, values));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        int count = ((IntToken)this.inputCount.getToken()).intValue();
        return this.input.hasToken(0, count) && super.prefire();
    }

    private void _addPoint(double value) {
        int bin = (int)Math.round((value - (this._minimumValue + this._binWidth * 0.5)) / this._binWidth);
        if (bin >= 0 && bin < this._numberOfBins) {
            int n = bin;
            this._bins[n] = this._bins[n] + 1;
        }
    }
}

