/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;

public class BooleanSwitch
extends TypedAtomicActor {
    public TypedIOPort control;
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort trueOutput;
    public TypedIOPort falseOutput;
    private boolean _control = false;

    public BooleanSwitch(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.control = new TypedIOPort(this, "control", true, false);
        this.control.setTypeEquals(BaseType.BOOLEAN);
        this.trueOutput = new TypedIOPort(this, "trueOutput", false, true);
        this.falseOutput = new TypedIOPort(this, "falseOutput", false, true);
        this.trueOutput.setTypeAtLeast(this.input);
        this.falseOutput.setTypeAtLeast(this.input);
        StringAttribute controlCardinal = new StringAttribute(this.control, "_cardinal");
        controlCardinal.setExpression("SOUTH");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.control.hasToken(0)) {
            this._control = ((BooleanToken)this.control.get(0)).booleanValue();
        }
        if (this.input.hasToken(0)) {
            Token token = this.input.get(0);
            if (this._control) {
                this.trueOutput.send(0, token);
            } else {
                this.falseOutput.send(0, token);
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._control = false;
    }
}

