/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.ArrayList;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ArrayPeakSearch
extends TypedAtomicActor {
    public Parameter dip = new Parameter(this, "dip");
    public PortParameter endIndex;
    public TypedIOPort input;
    public Parameter maximumNumberOfPeaks;
    public TypedIOPort peakIndices;
    public TypedIOPort peakValues;
    public StringParameter scale;
    public Parameter squelch;
    public PortParameter startIndex;
    private static final int _ABSOLUTE = 0;
    private static final int _RELATIVE_DB = 1;
    private static final int _RELATIVE_DB_POWER = 2;
    private static final int _RELATIVE_LINEAR = 3;

    public ArrayPeakSearch(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.dip.setExpression("0.0");
        this.dip.setTypeEquals(BaseType.DOUBLE);
        this.squelch = new Parameter(this, "squelch");
        this.squelch.setExpression("-10.0");
        this.squelch.setTypeEquals(BaseType.DOUBLE);
        this.scale = new StringParameter(this, "scale");
        this.scale.setExpression("absolute");
        this.scale.addChoice("absolute");
        this.scale.addChoice("relative linear");
        this.scale.addChoice("relative amplitude decibels");
        this.scale.addChoice("relative power decibels");
        this.startIndex = new PortParameter(this, "startIndex");
        this.startIndex.setExpression("0");
        this.startIndex.setTypeEquals(BaseType.INT);
        this.endIndex = new PortParameter(this, "endIndex");
        this.endIndex.setExpression("MaxInt");
        this.endIndex.setTypeEquals(BaseType.INT);
        this.maximumNumberOfPeaks = new Parameter(this, "maximumNumberOfPeaks");
        this.maximumNumberOfPeaks.setExpression("MaxInt");
        this.maximumNumberOfPeaks.setTypeEquals(BaseType.INT);
        this.input = new TypedIOPort(this, "input", true, false);
        this.peakValues = new TypedIOPort(this, "peakValues", false, true);
        this.peakIndices = new TypedIOPort(this, "peakIndices", false, true);
        new SingletonParameter(this.peakValues, "_showName").setToken(BooleanToken.TRUE);
        new SingletonParameter(this.peakIndices, "_showName").setToken(BooleanToken.TRUE);
        this.input.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.peakValues.setTypeAtLeast(this.input);
        this.peakIndices.setTypeEquals(new ArrayType(BaseType.INT));
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayPeakSearch newObject = (ArrayPeakSearch)super.clone(workspace);
        newObject.input.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        newObject.peakValues.setTypeAtLeast(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.startIndex.update();
        this.endIndex.update();
        if (this.input.hasToken(0)) {
            double indata;
            int i;
            double localMax;
            ArrayToken inputArray = (ArrayToken)this.input.get(0);
            Type inputElementType = inputArray.getElementType();
            int inputSize = inputArray.length();
            if (inputSize == 0) {
                this.peakValues.send(0, inputArray);
                this.peakIndices.send(0, inputArray);
                return;
            }
            int start = ((IntToken)this.startIndex.getToken()).intValue();
            int end = ((IntToken)this.endIndex.getToken()).intValue();
            int maxPeaks = ((IntToken)this.maximumNumberOfPeaks.getToken()).intValue();
            if (end >= inputSize) {
                end = inputSize - 1;
            }
            if (start >= inputSize) {
                start = inputSize - 1;
            }
            if (end < 0) {
                end = 0;
            }
            if (start < 0) {
                start = 0;
            }
            int increment = 1;
            if (end < start) {
                increment = -1;
            }
            boolean searchValley = false;
            boolean searchPeak = true;
            int localMaxIndex = start;
            double localMin = localMax = ((DoubleToken)inputArray.getElement(start)).doubleValue();
            double dipValue = ((DoubleToken)this.dip.getToken()).doubleValue();
            double squelchValue = ((DoubleToken)this.squelch.getToken()).doubleValue();
            double dipThreshold = dipValue;
            double riseThreshold = dipValue;
            String scaleValue = this.scale.stringValue();
            int scaleIndicator = 0;
            if (!scaleValue.equals("absolute")) {
                double maxValue = localMax;
                for (i = 0; i <= inputSize - 1; i += increment) {
                    indata = ((DoubleToken)inputArray.getElement(i)).doubleValue();
                    if (!(indata > maxValue)) continue;
                    maxValue = indata;
                }
                if (scaleValue.equals("relative amplitude decibels")) {
                    scaleIndicator = 1;
                    dipThreshold = localMax * Math.pow(10.0, -dipValue / 20.0);
                    riseThreshold = localMin * Math.pow(10.0, dipValue / 20.0);
                    squelchValue = maxValue * Math.pow(10.0, -squelchValue / 20.0);
                } else if (scaleValue.equals("relative power decibels")) {
                    scaleIndicator = 2;
                    dipThreshold = localMax * Math.pow(10.0, -dipValue / 10.0);
                    riseThreshold = localMin * Math.pow(10.0, dipValue / 10.0);
                    squelchValue = maxValue * Math.pow(10.0, -squelchValue / 10.0);
                } else if (scaleValue.equals("relative linear")) {
                    scaleIndicator = 3;
                    dipThreshold = localMax - dipValue;
                    riseThreshold = localMin + dipValue;
                    squelchValue = maxValue - squelchValue;
                }
            }
            ArrayList<Token> resultIndices = new ArrayList<Token>();
            ArrayList<Token> resultPeaks = new ArrayList<Token>();
            for (i = start; i <= end; i += increment) {
                indata = ((DoubleToken)inputArray.getElement(i)).doubleValue();
                if (this._debugging) {
                    this._debug("-- Checking input with value " + indata + " at index " + i);
                }
                if (searchValley) {
                    if (indata < localMin) {
                        localMin = indata;
                        switch (scaleIndicator) {
                            case 1: {
                                riseThreshold = localMin * Math.pow(10.0, dipValue / 20.0);
                                break;
                            }
                            case 2: {
                                riseThreshold = localMin * Math.pow(10.0, dipValue / 10.0);
                                break;
                            }
                            case 3: {
                                riseThreshold = localMin + dipValue;
                            }
                        }
                    }
                    if (this._debugging) {
                        this._debug("-- Looking for a value above " + riseThreshold);
                    }
                    if (!(indata > riseThreshold) || !(indata > squelchValue)) continue;
                    localMax = indata;
                    switch (scaleIndicator) {
                        case 1: {
                            dipThreshold = localMax * Math.pow(10.0, -dipValue / 20.0);
                            break;
                        }
                        case 2: {
                            dipThreshold = localMax * Math.pow(10.0, -dipValue / 10.0);
                            break;
                        }
                        case 3: {
                            dipThreshold = localMax - dipValue;
                        }
                    }
                    localMaxIndex = i;
                    searchValley = false;
                    searchPeak = true;
                    continue;
                }
                if (!searchPeak) continue;
                if (indata > localMax && indata > squelchValue) {
                    localMax = indata;
                    switch (scaleIndicator) {
                        case 1: {
                            dipThreshold = localMax * Math.pow(10.0, -dipValue / 20.0);
                            break;
                        }
                        case 2: {
                            dipThreshold = localMax * Math.pow(10.0, -dipValue / 10.0);
                            break;
                        }
                        case 3: {
                            dipThreshold = localMax - dipValue;
                        }
                    }
                    localMaxIndex = i;
                }
                if (this._debugging) {
                    this._debug("-- Looking for a value below " + dipThreshold);
                }
                if (!(indata < dipThreshold) || !(localMax > squelchValue)) continue;
                if (this._debugging) {
                    this._debug("** Found a peak with value " + localMax + " at index " + localMaxIndex);
                }
                resultIndices.add(new IntToken(localMaxIndex));
                resultPeaks.add(new DoubleToken(localMax));
                if (resultPeaks.size() > maxPeaks) break;
                localMin = indata;
                switch (scaleIndicator) {
                    case 1: {
                        riseThreshold = localMin * Math.pow(10.0, dipValue / 20.0);
                        break;
                    }
                    case 2: {
                        riseThreshold = localMin * Math.pow(10.0, dipValue / 10.0);
                        break;
                    }
                    case 3: {
                        riseThreshold = localMin + dipValue;
                    }
                }
                searchValley = true;
                searchPeak = false;
            }
            if (resultPeaks.isEmpty()) {
                resultPeaks.add(inputArray.getElement(start));
                resultIndices.add(this.startIndex.getToken());
            }
            Token[] resultPeaksArray = resultPeaks.toArray(new Token[resultPeaks.size()]);
            Token[] resultIndicesArray = resultIndices.toArray(new Token[resultIndices.size()]);
            this.peakValues.send(0, new ArrayToken(inputElementType, resultPeaksArray));
            this.peakIndices.send(0, new ArrayToken(BaseType.INT, resultIndicesArray));
        }
    }
}

