/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.unit;

import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.TransformContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class BasicEdgeHighlighter
extends FigureDecorator {
    private float _halo = 4.0f;
    private Paint _paint = new Color(255, 255, 0, 200);
    private Stroke _stroke = new BasicStroke(2.0f * this._halo);

    public boolean hit(Rectangle2D region) {
        return false;
    }

    public FigureDecorator newInstance(Figure f) {
        return new BasicEdgeHighlighter();
    }

    public void paint(Graphics2D g) {
        g.setPaint(this._paint);
        Shape shape = this.getChild().getShape();
        if (this._stroke != null) {
            g.setStroke(this._stroke);
        }
        g.draw(shape);
        this.getChild().paint(g);
    }

    public void repaint(DamageRegion d) {
        this.repaint();
    }

    public void repaint() {
        Rectangle2D bounds = this.getChild().getBounds();
        double x = bounds.getX() - (double)this._halo;
        double y = bounds.getY() - (double)this._halo;
        double w = bounds.getWidth() + (double)(2.0f * this._halo);
        double h = bounds.getHeight() + (double)(2.0f * this._halo);
        this.getParent().repaint(DamageRegion.createDamageRegion((TransformContext)this.getTransformContext(), (double)x, (double)y, (double)w, (double)h));
    }
}

