/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.actor.gui.TokenTableau;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class TokenEffigy
extends Effigy {
    private ArrayList _tokens = new ArrayList();
    private Variable _variable;

    public TokenEffigy(Workspace workspace) {
        super(workspace);
    }

    public TokenEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void append(Token token) throws IllegalActionException {
        this._tokens.add(token);
        for (TokenTableau tableau : this.entityList(TokenTableau.class)) {
            tableau.append(token);
        }
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.uri) {
            try {
                URL urlToRead = this.uri.getURL();
                if (urlToRead != null) {
                    this.read(urlToRead);
                }
            }
            catch (IOException ex) {
                throw new IllegalActionException(this, null, ex, "Failed to read data: " + ex.getMessage());
            }
        }
    }

    public void clear() {
        this._tokens.clear();
        for (TokenTableau tableau : this.entityList(TokenTableau.class)) {
            tableau.clear();
        }
    }

    public ArrayList getTokens() {
        return this._tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void read(URL input) throws IOException {
        block11: {
            if (input == null) {
                throw new IOException("Attempt to read from null input.");
            }
            reader = null;
            try {
                reader = new LineNumberReader(new InputStreamReader(input.openStream()));
                block5: while (true) {
                    if ((line = reader.readLine()) == null) {
                        break block11;
                    }
                    if (this._variable == null) {
                        this._variable = new Variable(this.workspace());
                        this._variable.setName("Expression evaluator");
                    }
                    this._variable.setExpression(line);
                    token = this._variable.getToken();
                    if (token == null) continue;
                    this._tokens.add(token);
                    tableaux = this.entityList(TokenTableau.class).iterator();
                    while (true) {
                        if (tableaux.hasNext()) ** break;
                        continue block5;
                        ((TokenTableau)tableaux.next()).append(token);
                    }
                    break;
                }
                catch (KernelException ex) {
                    throw new IOException("Error evaluating data expression: " + ex.getMessage());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void setTokens(List tokens) throws IllegalActionException {
        this._tokens.clear();
        this._tokens.addAll(tokens);
        for (TokenTableau tableau : this.entityList(TokenTableau.class)) {
            tableau.clear();
            tableau.append(tokens);
        }
    }

    @Override
    public void writeFile(File file) throws IOException {
        OutputStreamWriter writer = null;
        writer = file == null ? new OutputStreamWriter(System.out) : new FileWriter(file);
        PrintWriter print = new PrintWriter(writer);
        for (Token token : this._tokens) {
            print.println(token.toString());
        }
        print.close();
    }

    public static class Factory
    extends EffigyFactory {
        public Factory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public boolean canCreateBlankEffigy() {
            return false;
        }

        @Override
        public Effigy createEffigy(CompositeEntity container, URL base, URL input) throws Exception {
            String extension;
            if (input != null && (extension = Factory.getExtension(input)).equals("ptd")) {
                TokenEffigy effigy = new TokenEffigy(container, container.uniqueName("effigy"));
                effigy.uri.setURL(input);
                return effigy;
            }
            return null;
        }
    }
}

