/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import javax.swing.BoxLayout;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class RenameConfigurer
extends Query
implements ChangeListener,
QueryListener {
    private boolean _changed = false;
    private NamedObj _object;

    public RenameConfigurer(NamedObj object) {
        this.addQueryListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.setTextWidth(25);
        this._object = object;
        this.addLine("New name", "New name", object.getName());
        this.addTextArea("Display name", "Display name", object.getDisplayName());
        boolean nameShowing = false;
        nameShowing = object instanceof Port ? this._isPropertySet(this._object, "_showName") : !this._isPropertySet(this._object, "_hideName");
        this.addCheckBox("Show name", "Show name", nameShowing);
    }

    public void apply() {
        if (this._changed) {
            boolean previousShowName;
            String newName = this.getStringValue("New name");
            String displayName = StringUtilities.escapeForXML(this.getStringValue("Display name"));
            NamedObj parent = this._object.getContainer();
            String oldName = this._object.getName();
            String oldDisplayName = StringUtilities.escapeForXML(this._object.getDisplayName());
            StringBuffer moml = new StringBuffer("<");
            String elementName = this._object.getElementName();
            moml.append(elementName);
            moml.append(" name=\"");
            moml.append(oldName);
            moml.append("\">");
            if (!oldName.equals(newName)) {
                moml.append("<rename name=\"");
                moml.append(newName);
                moml.append("\"/>");
            }
            if (!oldDisplayName.equals(displayName)) {
                moml.append("<display name=\"");
                moml.append(displayName);
                moml.append("\"/>");
            }
            boolean showName = this.getBooleanValue("Show name");
            if (this._object instanceof Port) {
                previousShowName = this._isPropertySet(this._object, "_showName");
                if (showName != previousShowName) {
                    if (showName) {
                        moml.append("<property name=\"_showName\" class=\"ptolemy.data.expr.SingletonParameter\" value=\"true\"/>");
                    } else if (!(this._object.getAttribute("_showName") instanceof Parameter)) {
                        moml.append("<deleteProperty name=\"_showName\"/>");
                    } else {
                        moml.append("<property name=\"_showName\" class=\"ptolemy.data.expr.SingletonParameter\" value=\"false\"/>");
                    }
                }
            } else {
                boolean bl = previousShowName = !this._isPropertySet(this._object, "_hideName");
                if (showName != previousShowName) {
                    if (showName) {
                        if (!(this._object.getAttribute("_hideName") instanceof Parameter)) {
                            moml.append("<deleteProperty name=\"_hideName\"/>");
                        } else {
                            moml.append("<property name=\"_hideName\" class=\"ptolemy.data.expr.SingletonParameter\" value=\"false\"/>");
                        }
                    } else {
                        moml.append("<property name=\"_hideName\" class=\"ptolemy.data.expr.SingletonParameter\" value=\"true\"/>");
                    }
                }
            }
            moml.append("</");
            moml.append(elementName);
            moml.append(">");
            MoMLChangeRequest request = new MoMLChangeRequest(this, parent, moml.toString(), null);
            request.addChangeListener(this);
            request.setUndoable(true);
            parent.requestChange(request);
        }
    }

    @Override
    public void changeExecuted(ChangeRequest change) {
    }

    @Override
    public void changeFailed(ChangeRequest change, Exception exception) {
        if (change != null && change.getSource() != this) {
            return;
        }
        if (change != null && !change.isErrorReported()) {
            change.setErrorReported(true);
            MessageHandler.error("Rename failed: ", exception);
        }
    }

    @Override
    public void changed(String name) {
        this._changed = true;
    }

    private boolean _isPropertySet(NamedObj object, String name) {
        Attribute attribute = object.getAttribute(name);
        if (attribute == null) {
            return false;
        }
        if (attribute instanceof Parameter) {
            try {
                Token token = ((Parameter)attribute).getToken();
                if (token instanceof BooleanToken && !((BooleanToken)token).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalActionException e) {
                // empty catch block
            }
        }
        return true;
    }
}

