/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.JFrame;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PlotEffigy;
import ptolemy.actor.gui.PlotTableauFrame;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.plotml.PlotMLParser;
import ptolemy.util.MessageHandler;

public class PlotTableau
extends Tableau {
    public URIAttribute uri = new URIAttribute(this, "uri");
    private URL _toRead = null;

    public PlotTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.uri) {
            try {
                URL toRead = new URL(this.uri.getURI().toString());
                this._parseURL(toRead);
            }
            catch (MalformedURLException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Invalid URL specification.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void setFrame(JFrame frame) throws IllegalActionException {
        if (!(frame instanceof PlotTableauFrame)) {
            throw new IllegalActionException((Nameable)this, "Frame for PlotTableau must be an instance of PlotTableauFrame.");
        }
        super.setFrame(frame);
        ((PlotTableauFrame)frame).setTableau(this);
    }

    @Override
    public void show() {
        JFrame frame = this.getFrame();
        if (frame == null) {
            PlotTableauFrame newFrame = new PlotTableauFrame(this);
            newFrame.plot.setButtons(true);
            try {
                this.setFrame(newFrame);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(ex);
            }
        }
        if (this._toRead != null) {
            this._parseURL(this._toRead);
        }
        super.show();
    }

    private void _parseURL(URL url) {
        try {
            PlotTableauFrame frame = (PlotTableauFrame)this.getFrame();
            if (frame != null) {
                PlotMLParser parser = new PlotMLParser((Plot)frame.plot);
                InputStream stream = url.openStream();
                parser.parse(url, stream);
                stream.close();
                this._toRead = null;
            } else {
                this._toRead = url;
            }
        }
        catch (Exception ex) {
            MessageHandler.error("Failed to read plot data: " + url.toExternalForm(), ex);
        }
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof PlotEffigy) {
                URI uri;
                PlotBox plotBox;
                effigy.setTableauFactory(this);
                PlotTableau tableau = (PlotTableau)effigy.getEntity("plotTableau");
                if (tableau == null) {
                    tableau = new PlotTableau(effigy, "plotTableau");
                }
                if ((plotBox = ((PlotEffigy)effigy).getPlot()) != null) {
                    PlotTableauFrame plotterFrame = new PlotTableauFrame((Tableau)tableau, plotBox);
                    tableau.setFrame(plotterFrame);
                }
                if ((uri = effigy.uri.getURI()) != null) {
                    tableau.uri.setURI(uri);
                }
                return tableau;
            }
            return null;
        }
    }
}

