/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.UIManager;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.Documentation;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;
import ptolemy.moml.filter.RemoveGraphicalClasses;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class MoMLApplication
implements ExecutionListener {
    protected String _basePath = "ptolemy/configs";
    protected String[] _commandFlags = new String[]{"-help", "-run", "-runThenExit", "-test", "-version"};
    protected static String[][] _commandOptions = new String[][]{{"-class", "<classname>"}, {"-<parameter name>", "<parameter value>"}};
    protected String _commandTemplate = "moml [ options ] [file ...]";
    protected Configuration _configuration;
    protected boolean _exit = false;
    protected MoMLParser _parser;
    protected boolean _run = false;
    protected static boolean _test = false;
    private int _activeCount = 0;
    private boolean _expectingClass = false;
    private List _parameterNames = new LinkedList();
    private List _parameterValues = new LinkedList();
    private static URL _initialSpecificationURL;

    public MoMLApplication(String[] args) throws Exception {
        this("ptolemy/configs", args);
    }

    public MoMLApplication(String basePath, String[] args) throws Exception {
        this._basePath = basePath;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this._parser = new MoMLParser();
        MoMLParser.setMoMLFilters(BackwardCompatibility.allFilters());
        MessageHandler.setMessageHandler(new GraphicalMessageHandler());
        try {
            Locale.setDefault(Locale.US);
        }
        catch (AccessControlException accessControl) {
            // empty catch block
        }
        try {
            this._parseArgs(args);
            if (this._run) {
                this.runModels();
                if (this._exit) {
                    Thread waitThread = new Thread(){

                        @Override
                        public void run() {
                            MoMLApplication.this.waitForFinish();
                            StringUtilities.exit(0);
                        }
                    };
                    waitThread.start();
                }
            }
        }
        catch (Throwable ex) {
            MoMLApplication.throwArgsException(ex, args);
        }
    }

    @Override
    public synchronized void executionError(Manager manager, Throwable throwable) {
        --this._activeCount;
        if (this._activeCount == 0) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void executionFinished(Manager manager) {
        --this._activeCount;
        if (this._activeCount == 0) {
            this.notifyAll();
        }
    }

    public static void main(String[] args) {
        try {
            new MoMLApplication(args);
        }
        catch (Throwable throwable) {
            MessageHandler.error("Command failed", throwable);
            System.err.print(KernelException.stackTraceToString(throwable));
            System.exit(1);
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    @Override
    public void managerStateChanged(Manager manager) {
    }

    public List models() {
        LinkedList<NamedObj> result = new LinkedList<NamedObj>();
        if (this._configuration == null) {
            return result;
        }
        ModelDirectory directory = (ModelDirectory)this._configuration.getEntity("directory");
        for (Effigy effigy : directory.entityList()) {
            if (!(effigy instanceof PtolemyEffigy)) continue;
            NamedObj model = ((PtolemyEffigy)effigy).getModel();
            result.add(model);
        }
        return result;
    }

    public static Configuration readConfiguration(URL specificationURL) throws Exception {
        StringParameter applicationInitializerParameter;
        if (_initialSpecificationURL == null) {
            _initialSpecificationURL = specificationURL;
        }
        MoMLParser parser = new MoMLParser();
        parser.reset();
        Configuration configuration = (Configuration)parser.parse(specificationURL, specificationURL);
        ComponentEntity directory = configuration.getEntity("directory");
        if (directory instanceof ModelDirectory) {
            PtolemyEffigy effigy = null;
            try {
                effigy = new PtolemyEffigy((ModelDirectory)directory, configuration.getName());
            }
            catch (NameDuplicationException ex) {
                PtolemyEffigy oldEffigy = (PtolemyEffigy)((ModelDirectory)directory).getEntity(configuration.getName());
                oldEffigy.setContainer(null);
                effigy = new PtolemyEffigy((ModelDirectory)directory, configuration.getName());
            }
            effigy.setModel(configuration);
            effigy.identifier.setExpression(specificationURL.toExternalForm());
        }
        if ((applicationInitializerParameter = (StringParameter)configuration.getAttribute("_applicationInitializer", Parameter.class)) != null) {
            String applicationInitializerClassName = applicationInitializerParameter.stringValue();
            try {
                Class<?> applicationInitializer = Class.forName(applicationInitializerClassName);
                applicationInitializer.newInstance();
            }
            catch (Throwable throwable) {
                throw new Exception("Failed to call application initializer class \"" + applicationInitializerClassName + "\".  Perhaps the configuration file \"" + specificationURL + "\" has a problem?", throwable);
            }
        }
        return configuration;
    }

    public void runModels() throws IllegalActionException {
        for (NamedObj model : this.models()) {
            if (!(model instanceof CompositeActor)) continue;
            CompositeActor actor = (CompositeActor)model;
            Manager manager = actor.getManager();
            if (manager == null) {
                manager = new Manager(actor.workspace(), "manager");
                actor.setManager(manager);
            }
            manager.addExecutionListener(this);
            ++this._activeCount;
            manager.startRun();
        }
    }

    public static URL specToURL(String spec) throws IOException {
        URL specURL = null;
        try {
            specURL = new URL(null, spec);
            InputStream urlStream = specURL.openStream();
            urlStream.close();
            return specURL;
        }
        catch (Exception ex) {
            try {
                File file = new File(spec);
                File absoluteFile = file.getAbsoluteFile();
                try {
                    if (!absoluteFile.exists()) {
                        throw new IOException("File '" + absoluteFile + "' does not exist.");
                    }
                }
                catch (AccessControlException accessControl) {
                    IOException exception = new IOException("AccessControlException while trying to read '" + absoluteFile + "'");
                    exception.initCause(accessControl);
                    throw exception;
                }
                specURL = absoluteFile.getCanonicalFile().toURI().toURL();
                return specURL;
            }
            catch (Exception ex2) {
                try {
                    specURL = Thread.currentThread().getContextClassLoader().getResource(spec);
                    if (specURL == null) {
                        throw new Exception("getResource(\"" + spec + "\") returned null.");
                    }
                    specURL = JNLPUtilities.canonicalizeJarURL(specURL);
                    InputStream urlStream = specURL.openStream();
                    urlStream.close();
                    return specURL;
                }
                catch (Exception ex3) {
                    IOException exception = new IOException("File not found: '" + spec + "'\n caused by:\n" + ex + "\n AND:\n" + ex2 + "\n AND:\n" + ex3);
                    exception.initCause(ex3);
                    throw exception;
                }
            }
        }
    }

    public static void throwArgsException(Throwable cause, String[] args) throws Exception {
        StringBuffer argsStringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (argsStringBuffer.length() > 0) {
                    argsStringBuffer.append(" ");
                }
                argsStringBuffer.append(args[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Exception("Failed to parse \"" + argsStringBuffer.toString() + "\"", cause);
    }

    public synchronized void waitForFinish() {
        while (this._activeCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _configurationUsage(String commandTemplate, String[][] commandOptions, String[] commandFlags) {
        StringBuffer result;
        block15: {
            int i;
            result = new StringBuffer("Usage: " + commandTemplate + "\n\n" + "Options that take values:\n");
            for (i = 0; i < _commandOptions.length; ++i) {
                result.append(" " + _commandOptions[i][0] + " " + _commandOptions[i][1] + "\n");
            }
            for (i = 0; i < commandOptions.length; ++i) {
                result.append(" " + commandOptions[i][0] + " " + commandOptions[i][1] + "\n");
            }
            result.append("\nFlags (do not take values):\n");
            for (i = 0; i < this._commandFlags.length; ++i) {
                result.append(" " + this._commandFlags[i] + "\n");
            }
            for (i = 0; i < commandFlags.length; ++i) {
                result.append(" " + commandFlags[i] + "\n");
            }
            try {
                URI configurationURI = new URI(MoMLApplication.specToURL(this._basePath).toExternalForm().replaceAll(" ", "%20"));
                File configurationDirectory = new File(configurationURI);
                ConfigurationFilenameFilter filter = new ConfigurationFilenameFilter();
                File[] configurationDirectories = configurationDirectory.listFiles(filter);
                if (configurationDirectories == null) break block15;
                result.append("\nThe following (mutually exclusive) flags specify alternative configurations:\n");
                for (i = 0; i < configurationDirectories.length; ++i) {
                    boolean printDefaultConfigurationMessage;
                    String configurationFileName;
                    block16: {
                        String configurationName = configurationDirectories[i].getName();
                        result.append(" -" + configurationName);
                        for (int j = configurationName.length(); j < 20; ++j) {
                            result.append(" ");
                        }
                        configurationFileName = configurationDirectories[i] + File.separator + "configuration.xml";
                        printDefaultConfigurationMessage = true;
                        try {
                            Configuration configuration;
                            if (configurationName.equals("jxta")) break block16;
                            URL specificationURL = MoMLApplication.specToURL(configurationFileName);
                            if (specificationURL.equals(_initialSpecificationURL)) {
                                configuration = this._configuration;
                                break block16;
                            }
                            ErrorHandler errorHandler = MoMLParser.getErrorHandler();
                            try {
                                MoMLParser.setErrorHandler(new IgnoreErrorHandler());
                                configuration = MoMLApplication.readConfiguration(specificationURL);
                            }
                            finally {
                                MoMLParser.setErrorHandler(errorHandler);
                            }
                            if (configuration != null && configuration.getAttribute("_doc") != null && configuration.getAttribute("_doc") instanceof Documentation) {
                                Documentation doc = (Documentation)configuration.getAttribute("_doc");
                                result.append("\t\t" + doc.getValueAsString() + "\n");
                                printDefaultConfigurationMessage = false;
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (!printDefaultConfigurationMessage) continue;
                    result.append("\t\tuses " + configurationFileName + "\n");
                }
            }
            catch (Exception ex) {
                result.append("Warning: Failed to find configuration(s) in '" + this._basePath + "': " + ex);
            }
        }
        return result.toString();
    }

    protected Configuration _createDefaultConfiguration() throws Exception {
        try {
            StringUtilities.mergePropertiesFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Configuration _createEmptyConfiguration() throws Exception {
        return this._createDefaultConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean _parseArg(String arg) throws Exception {
        URL inURL;
        if (arg.equals("-class")) {
            this._expectingClass = true;
            return true;
        }
        if (arg.equals("-help")) {
            System.out.println(this._usage());
            StringUtilities.exit(0);
            return true;
        }
        if (arg.equals("-run")) {
            this._run = true;
            return true;
        }
        if (arg.equals("-runThenExit")) {
            this._run = true;
            this._exit = true;
            return true;
        }
        if (arg.equals("-test")) {
            _test = true;
            return true;
        }
        if (arg.equals("-version")) {
            System.out.println("Version " + VersionAttribute.CURRENT_VERSION.getExpression() + ", Build $Id: MoMLApplication.java,v 1.148.4.2 2008/01/29 07:35:36 cxh Exp $");
            StringUtilities.exit(0);
            return true;
        }
        if (arg.equals("")) return true;
        if (this._expectingClass) {
            this._expectingClass = false;
            Class<?> newClass = Class.forName(arg);
            Workspace workspace = new Workspace();
            Class[] argTypes = new Class[]{workspace.getClass()};
            Constructor<?> constructor = newClass.getConstructor(argTypes);
            Object[] args = new Object[]{workspace};
            NamedObj newModel = (NamedObj)constructor.newInstance(args);
            System.out.println("-class: _configuration: " + this._configuration);
            if (this._configuration != null) {
                this._configuration.openModel(newModel);
                return true;
            }
            System.err.println("No configuration found.");
            throw new IllegalActionException((Nameable)newModel, "No configuration found.");
        }
        if (arg.startsWith("-")) return false;
        try {
            inURL = MoMLApplication.specToURL(arg);
        }
        catch (Exception ex) {
            try {
                inURL = new URL(new URL("file://./"), arg);
            }
            catch (Exception ex2) {
                File inFile = new File(arg);
                inURL = inFile.toURI().toURL();
            }
        }
        URL base = inURL;
        if (this._configuration != null) {
            ModelDirectory directory = (ModelDirectory)this._configuration.getEntity("directory");
            if (directory == null) {
                throw new InternalErrorException("No model directory!");
            }
            String key = inURL.toExternalForm();
            this._configuration.openModel(base, inURL, key);
            return true;
        }
        this._parser.reset();
        try {
            NamedObj toplevel = this._parser.parse(base, inURL);
            if (!(toplevel instanceof Configuration)) return true;
            this._configuration = (Configuration)toplevel;
            return true;
        }
        catch (Exception ex) {
            String detailMessage = "";
            try {
                if (inURL.toString().indexOf("!/") == -1 || inURL.toString().indexOf("%20") == -1) throw new Exception("Failed to parse '" + inURL + "'" + detailMessage, ex);
                detailMessage = " The URL contains '!/', so it may be a jar URL, and jar URLs cannot contain %20. This might happen if the pathname to the jnlp file had a space in it";
                throw new Exception("Failed to parse '" + inURL + "'" + detailMessage, ex);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw new Exception("Failed to parse '" + inURL + "'" + detailMessage, ex);
        }
    }

    protected void _parseArgs(String[] args) throws Exception {
        this._configuration = args.length > 0 ? this._createDefaultConfiguration() : this._createEmptyConfiguration();
        Parameter classesToRemoveParameter = (Parameter)this._configuration.getAttribute("_classesToRemove");
        if (classesToRemoveParameter != null) {
            ArrayToken classesToRemoveToken = (ArrayToken)classesToRemoveParameter.getToken();
            RemoveGraphicalClasses filter = new RemoveGraphicalClasses();
            filter.clear();
            for (int i = 0; i < classesToRemoveToken.length(); ++i) {
                String classNameToRemove = ((StringToken)classesToRemoveToken.getElement(i)).stringValue();
                filter.put(classNameToRemove, null);
            }
            MoMLParser.addMoMLFilter(filter);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this._parseArg(arg)) continue;
            if (arg.trim().startsWith("-")) {
                if (i >= args.length - 1) {
                    throw new IllegalActionException("Cannot set parameter " + arg + " when no value is " + "given.");
                }
                this._parameterNames.add(arg.substring(1));
                this._parameterValues.add(args[i + 1]);
                ++i;
                continue;
            }
            throw new IllegalActionException("Unrecognized option: " + arg);
        }
        if (this._expectingClass) {
            throw new IllegalActionException("Missing classname.");
        }
        Iterator names = this._parameterNames.iterator();
        Iterator values = this._parameterValues.iterator();
        while (names.hasNext() && values.hasNext()) {
            String name = (String)names.next();
            String value = (String)values.next();
            boolean match = false;
            ModelDirectory directory = (ModelDirectory)this._configuration.getEntity("directory");
            if (directory == null) {
                throw new InternalErrorException("No model directory!");
            }
            for (Effigy effigy : directory.entityList(Effigy.class)) {
                Director director;
                if (!(effigy instanceof PtolemyEffigy)) continue;
                NamedObj model = ((PtolemyEffigy)effigy).getModel();
                Attribute attribute = model.getAttribute(name);
                if (attribute instanceof Settable) {
                    match = true;
                    String moml = "<property name=\"" + name + "\" value=\"" + value + "\"/>";
                    MoMLChangeRequest request = new MoMLChangeRequest(this, model, moml);
                    model.requestChange(request);
                }
                if (!(model instanceof CompositeActor) || (director = ((CompositeActor)model).getDirector()) == null || !((attribute = director.getAttribute(name)) instanceof Settable)) continue;
                match = true;
                String moml = "<property name=\"" + name + "\" value=\"" + value + "\"/>";
                MoMLChangeRequest request = new MoMLChangeRequest(this, director, moml);
                director.requestChange(request);
            }
            if (match) continue;
            throw new IllegalActionException("Unrecognized option: No parameter exists with name " + name);
        }
        if (this._configuration == null) {
            throw new IllegalActionException("No configuration provided.");
        }
        this._configuration.showAll();
    }

    protected Configuration _readConfiguration(URL specificationURL) throws Exception {
        return MoMLApplication.readConfiguration(specificationURL);
    }

    protected String _usage() {
        return StringUtilities.usageString(this._commandTemplate, _commandOptions, this._commandFlags);
    }

    public static class IgnoreErrorHandler
    implements ErrorHandler {
        @Override
        public void enableErrorSkipping(boolean enable) {
        }

        @Override
        public int handleError(String element, NamedObj context, Throwable exception) {
            return 0;
        }
    }

    static class ConfigurationFilenameFilter
    implements FilenameFilter {
        ConfigurationFilenameFilter() {
        }

        @Override
        public boolean accept(File directory, String name) {
            try {
                File configurationDirectory = new File(directory, name);
                if (!configurationDirectory.isDirectory()) {
                    return false;
                }
                File configurationFile = new File(configurationDirectory, "configuration.xml");
                File introFile = new File(configurationDirectory, "intro.htm");
                if (configurationFile.isFile() && introFile.isFile()) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
            return false;
        }
    }
}

