/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.EditorPaneFactory;
import ptolemy.gui.CloseListener;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.StringUtilities;

public class Configurer
extends JPanel
implements CloseListener {
    private List _closeListeners = new LinkedList();
    private NamedObj _object;
    private HashMap _originalValues;

    public Configurer(NamedObj object) {
        this.setLayout(new BoxLayout(this, 1));
        this._object = object;
        this._originalValues = new HashMap();
        for (Settable parameter : this._object.attributeList(Settable.class)) {
            if (!Configurer.isVisible(this._object, parameter)) continue;
            this._originalValues.put(parameter, parameter.getExpression());
        }
        boolean foundOne = false;
        Iterator editors = object.attributeList(EditorPaneFactory.class).iterator();
        while (editors.hasNext()) {
            foundOne = true;
            EditorPaneFactory editor = (EditorPaneFactory)editors.next();
            Component pane = editor.createEditorPane();
            this.add(pane);
            pane.setBackground(null);
            if (!(pane instanceof CloseListener)) continue;
            this._closeListeners.add(pane);
        }
        if (!foundOne) {
            Component pane = EditorPaneFactory.createEditorPane(object);
            this.add(pane);
            pane.setBackground(null);
            if (pane instanceof CloseListener) {
                this._closeListeners.add(pane);
            }
        }
    }

    public static boolean isVisible(NamedObj target, Settable settable) {
        if (settable.getVisibility() == Settable.FULL || settable.getVisibility() == Settable.NOT_EDITABLE) {
            return true;
        }
        return target.getAttribute("_expertMode") != null && settable.getVisibility() == Settable.EXPERT;
    }

    public void restore() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Iterator parameters = Configurer.this._object.attributeList(Settable.class).iterator();
                boolean hasChanges = false;
                StringBuffer buffer = new StringBuffer("<group>\n");
                while (parameters.hasNext()) {
                    String oldValue;
                    String newValue;
                    Settable parameter = (Settable)parameters.next();
                    if (!Configurer.isVisible(Configurer.this._object, parameter) || (newValue = parameter.getExpression()).equals(oldValue = (String)Configurer.this._originalValues.get(parameter))) continue;
                    hasChanges = true;
                    buffer.append("<property name=\"");
                    buffer.append(((NamedObj)((Object)parameter)).getName(Configurer.this._object));
                    buffer.append("\" value=\"");
                    buffer.append(StringUtilities.escapeForXML(oldValue));
                    buffer.append("\"/>\n");
                }
                buffer.append("</group>\n");
                if (hasChanges) {
                    MoMLChangeRequest request = new MoMLChangeRequest(this, Configurer.this._object, buffer.toString(), null);
                    Configurer.this._object.requestChange(request);
                }
            }
        });
    }

    public void restoreToDefaults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Iterator parameters = Configurer.this._object.attributeList(Settable.class).iterator();
                StringBuffer buffer = new StringBuffer("<group>\n");
                final LinkedList<Settable> parametersReset = new LinkedList<Settable>();
                while (parameters.hasNext()) {
                    Settable parameter = (Settable)parameters.next();
                    if (!Configurer.isVisible(Configurer.this._object, parameter)) continue;
                    String newValue = parameter.getExpression();
                    String defaultValue = parameter.getDefaultExpression();
                    if (defaultValue == null || newValue.equals(defaultValue)) continue;
                    buffer.append("<property name=\"");
                    buffer.append(((NamedObj)((Object)parameter)).getName(Configurer.this._object));
                    buffer.append("\" value=\"");
                    buffer.append(StringUtilities.escapeForXML(defaultValue));
                    buffer.append("\"/>\n");
                    parametersReset.add(parameter);
                }
                buffer.append("</group>\n");
                if (parametersReset.size() > 0) {
                    MoMLChangeRequest request = new MoMLChangeRequest(this, Configurer.this._object, buffer.toString(), null){

                        @Override
                        protected void _execute() throws Exception {
                            super._execute();
                            for (Settable parameter : parametersReset) {
                                if (!Configurer.isVisible(Configurer.this._object, parameter)) continue;
                                int derivedLevel = ((NamedObj)((Object)parameter)).getDerivedLevel();
                                ((NamedObj)((Object)parameter)).setDerivedLevel(derivedLevel);
                            }
                        }
                    };
                    Configurer.this._object.requestChange(request);
                }
            }
        });
    }

    @Override
    public void windowClosed(Window window, String button) {
        for (CloseListener listener : this._closeListeners) {
            listener.windowClosed(window, button);
        }
    }
}

