/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ColorAttribute
extends Parameter {
    public ColorAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setTypeEquals(new ArrayType(BaseType.DOUBLE));
    }

    public Color asColor() {
        try {
            ArrayToken spec = (ArrayToken)this.getToken();
            int length = 0;
            if (spec != null) {
                length = spec.length();
            }
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            float alpha = 1.0f;
            if (length > 0) {
                red = (float)((DoubleToken)spec.getElement(0)).doubleValue();
            }
            if (length > 1) {
                green = (float)((DoubleToken)spec.getElement(1)).doubleValue();
            }
            if (length > 2) {
                blue = (float)((DoubleToken)spec.getElement(2)).doubleValue();
            }
            if (length > 3) {
                alpha = (float)((DoubleToken)spec.getElement(3)).doubleValue();
            }
            return new Color(red, green, blue, alpha);
        }
        catch (IllegalActionException ex) {
            return Color.black;
        }
    }
}

