/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.List;
import ptolemy.actor.gt.NamedObjToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class NamedObjVariable
extends Variable {
    private boolean _setTokenWithContainer = false;
    public static final String NAME_PREFIX = "namedObjVariable";

    public NamedObjVariable(NamedObj container) throws IllegalActionException, NameDuplicationException {
        this(container, container.uniqueName(NAME_PREFIX));
    }

    public NamedObjVariable(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setToken(new NamedObjToken(container));
        this._setTokenWithContainer = true;
        this.setPersistent(false);
    }

    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        NamedObj oldContainer = this.getContainer();
        super.setContainer(container);
        if (this._setTokenWithContainer && container != oldContainer) {
            this.setToken(new NamedObjToken(container));
        }
    }

    @Override
    public void setToken(Token token) throws IllegalActionException {
        if (token instanceof NamedObjToken) {
            if (!((NamedObjToken)token).getObject().equals(this.getContainer())) {
                throw new IllegalActionException("The NamedObj in the token is not equal to the container of this variable.");
            }
        } else {
            throw new IllegalActionException("Only instances of NamedObjToken are allowed as argument of setToken().");
        }
        super.setToken(token);
    }

    public static NamedObjVariable getNamedObjVariable(NamedObj container, boolean autoCreate) throws IllegalActionException {
        List attributes = container.attributeList(NamedObjVariable.class);
        if (attributes.isEmpty()) {
            if (autoCreate) {
                try {
                    return new NamedObjVariable(container);
                }
                catch (NameDuplicationException e) {
                    throw new InternalErrorException(e);
                }
            }
            return null;
        }
        return (NamedObjVariable)attributes.get(0);
    }
}

