/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ptolemy.actor.gt.ActorScopeExtender;
import ptolemy.actor.gt.FakedRecordToken;
import ptolemy.actor.gt.GTEntity;
import ptolemy.actor.gt.GTTools;
import ptolemy.actor.gt.NamedObjVariable;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;

public class NamedObjToken
extends FakedRecordToken {
    private Set<String> _labelSet;
    private NamedObj _object;
    private long _version = -1L;

    public NamedObjToken(NamedObj object) throws IllegalActionException {
        this._object = object;
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof NamedObjToken && ((NamedObjToken)object)._object.equals(this._object);
    }

    @Override
    public Token get(String label) {
        Token token;
        if (this._object instanceof GTEntity && (token = ((GTEntity)((Object)this._object)).getIngredientToken(label)) != null) {
            return token;
        }
        NamedObj child = GTTools.getChild(this._object, label, true, true, true, true);
        if (child instanceof ActorScopeExtender) {
            child = GTTools.getChild(this._object, label, false, true, true, true);
        }
        try {
            if (child instanceof Variable) {
                return ((Variable)child).getToken();
            }
            return NamedObjVariable.getNamedObjVariable(child, true).getToken();
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }

    public NamedObj getObject() {
        return this._object;
    }

    @Override
    public int hashCode() {
        return this._object.hashCode();
    }

    @Override
    public BooleanToken isEqualTo(Token rightArgument) throws IllegalActionException {
        return this._isEqualTo(rightArgument);
    }

    @Override
    public Set<String> labelSet() {
        long version = this._object.workspace().getVersion();
        if (this._labelSet == null || version > this._version) {
            Set<String> labelSet;
            this._labelSet = new HashSet<String>();
            if (this._object instanceof GTEntity && (labelSet = ((GTEntity)((Object)this._object)).labelSet()) != null) {
                this._labelSet.addAll(labelSet);
            }
            Collection<?> children = GTTools.getChildren(this._object, true, true, true, true);
            for (Object childObject : children) {
                NamedObj child = (NamedObj)childObject;
                if (child instanceof ActorScopeExtender) continue;
                this._labelSet.add(child.getName());
            }
            this._version = version;
        }
        return this._labelSet;
    }

    @Override
    public int length() {
        return this.labelSet().size();
    }

    @Override
    protected BooleanToken _isEqualTo(Token object) throws IllegalActionException {
        return BooleanToken.getInstance(this.equals(object));
    }
}

