/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.Director;
import ptolemy.actor.gt.GTEntity;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.GTIngredientsAttribute;
import ptolemy.actor.gt.GTTools;
import ptolemy.actor.gt.MalformedStringException;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.RelationHidingAttribute;
import ptolemy.actor.gt.Replacement;
import ptolemy.actor.gt.ReplacementObjectAttribute;
import ptolemy.actor.gt.TransformationAttribute;
import ptolemy.actor.gt.TransformationException;
import ptolemy.actor.gt.TransformationRule;
import ptolemy.actor.gt.data.MatchResult;
import ptolemy.actor.gt.data.Pair;
import ptolemy.actor.gt.data.TwoWayHashMap;
import ptolemy.actor.gt.ingredients.operations.Operation;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.Vertex;
import ptolemy.vergil.kernel.attributes.VisibleAttribute;

public class GraphTransformer
extends ChangeRequest {
    private CompositeEntity _host;
    private MatchResult _matchResult;
    private List<MatchResult> _matchResults;
    private Map<NamedObj, String> _moml;
    private Pattern _pattern;
    private TwoWayHashMap<NamedObj, NamedObj> _patternToReplacement;
    private Replacement _replacement;
    private TwoWayHashMap<NamedObj, NamedObj> _replacementToHost;

    public GraphTransformer(TransformationRule transformationRule, List<MatchResult> matchResults) throws TransformationException {
        super(null, "Apply graph transformation to model.");
        this._pattern = transformationRule.getPattern();
        this._replacement = transformationRule.getReplacement();
        this._matchResults = matchResults;
    }

    public GraphTransformer(TransformationRule transformationRule, MatchResult matchResult) throws TransformationException {
        super(null, "Apply graph transformation to model.");
        this._pattern = transformationRule.getPattern();
        this._replacement = transformationRule.getReplacement();
        this._matchResults = new LinkedList<MatchResult>();
        this._matchResults.add(matchResult);
    }

    public MatchResult getMatchResult() {
        return this._matchResult;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public Replacement getReplacement() {
        return this._replacement;
    }

    public static void transform(TransformationRule transformationRule, List<MatchResult> matchResults) throws TransformationException {
        if (matchResults.isEmpty()) {
            return;
        }
        GraphTransformer transformer = new GraphTransformer(transformationRule, matchResults);
        MatchResult matchResult = matchResults.get(0);
        NamedObj host = (NamedObj)matchResult.get(transformationRule.getPattern());
        if (host == null) {
            throw new TransformationException("Match result is invalid because it does not include the pattern.");
        }
        host.requestChange(transformer);
    }

    public static void transform(TransformationRule transformationRule, MatchResult matchResult) throws TransformationException {
        GraphTransformer transformer = new GraphTransformer(transformationRule, matchResult);
        NamedObj host = (NamedObj)matchResult.get(transformationRule.getPattern());
        if (host == null) {
            throw new TransformationException("Match result is invalid because it does not include the pattern.");
        }
        host.requestChange(transformer);
    }

    protected void _addConnections() throws TransformationException {
        for (NamedObj replacement : this._replacementToHost.keySet()) {
            List hostLinkdList;
            List replacementLinkedList;
            if (!(replacement instanceof Port) && !(replacement instanceof Relation)) continue;
            NamedObj host = (NamedObj)this._replacementToHost.get(replacement);
            if (replacement instanceof Port && host instanceof Port) {
                replacementLinkedList = ((Port)replacement).linkedRelationList();
                hostLinkdList = ((Port)host).linkedRelationList();
            } else {
                if (!(replacement instanceof Relation) || !(host instanceof Relation)) continue;
                replacementLinkedList = ((Relation)replacement).linkedObjectsList();
                hostLinkdList = ((Relation)host).linkedObjectsList();
            }
            for (Object replacementLinkedObjectRaw : replacementLinkedList) {
                NamedObj replacementLinkedObject = (NamedObj)replacementLinkedObjectRaw;
                NamedObj hostLinkedObject = (NamedObj)this._replacementToHost.get(replacementLinkedObject);
                if (hostLinkedObject == null || hostLinkdList.contains(hostLinkedObject)) continue;
                Relation relation = hostLinkedObject instanceof Relation ? (Relation)hostLinkedObject : (Relation)host;
                NamedObj hostContainer = relation.getContainer();
                String moml = relation == hostLinkedObject ? this._getLinkMoML(host, relation) : this._getLinkMoML(hostLinkedObject, relation);
                MoMLChangeRequest request = new MoMLChangeRequest(this, hostContainer, moml);
                request.execute();
            }
            if (!(replacement instanceof ComponentPort) || !(host instanceof ComponentPort)) continue;
            ComponentPort replacementComponentPort = (ComponentPort)replacement;
            ComponentPort hostComponentPort = (ComponentPort)host;
            for (Object replacementRelationObject : replacementComponentPort.insideRelationList()) {
                Relation replacementRelation = (Relation)replacementRelationObject;
                Relation hostRelation = (Relation)this._replacementToHost.get(replacementRelation);
                if (hostComponentPort.insideRelationList().contains(hostRelation)) continue;
                NamedObj hostContainer = hostRelation.getContainer();
                String moml = this._getLinkMoML(host, hostRelation);
                MoMLChangeRequest request = new MoMLChangeRequest(this, hostContainer, moml);
                request.execute();
            }
        }
    }

    protected void _addObjects() throws TransformationException {
        this._addObjects(this._replacement, this._host);
    }

    @Override
    protected void _execute() throws TransformationException {
        for (MatchResult matchResult : this._matchResults) {
            this._matchResult = (MatchResult)matchResult.clone();
            this._host = (CompositeEntity)this._matchResult.get(this._pattern);
            if (this._host == null) {
                throw new TransformationException("Match result is invalid because it does not include the pattern.");
            }
            this._init();
            this._recordMoML();
            this._addObjects();
            this._performOperations();
            this._removeLinks();
            this._removeObjects();
            this._addConnections();
            this._wrapup();
        }
        this._hideRelations();
    }

    protected void _hideRelations() throws TransformationException {
        this._hideRelations(this._host);
    }

    protected void _init() throws TransformationException {
        this._patternToReplacement = new TwoWayHashMap();
        this._initPatternToReplacement(this._replacement);
        this._initReplacementToHost();
        this._initReplacementObjectAttributes(this._replacement);
    }

    protected void _performOperations() throws TransformationException {
        for (Map.Entry entry : this._replacementToHost.entrySet()) {
            NamedObj replacement = (NamedObj)entry.getKey();
            NamedObj host = (NamedObj)entry.getValue();
            NamedObj pattern = this._patternToReplacement.getKey(replacement);
            if (pattern != null && !(pattern instanceof Entity) || !(replacement instanceof Entity) || !(host instanceof Entity)) continue;
            try {
                GTIngredientList ingredientList;
                Entity patternEntity = (Entity)pattern;
                Entity replacementEntity = (Entity)replacement;
                Entity hostEntity = (Entity)host;
                if (replacementEntity instanceof GTEntity) {
                    ingredientList = ((GTEntity)((Object)replacementEntity)).getOperationsAttribute().getIngredientList();
                } else {
                    List attributes = replacementEntity.attributeList(GTIngredientsAttribute.class);
                    if (attributes.isEmpty()) continue;
                    ingredientList = ((GTIngredientsAttribute)attributes.get(0)).getIngredientList();
                }
                for (GTIngredient ingredient : ingredientList) {
                    try {
                        ChangeRequest request = ((Operation)ingredient).getChangeRequest(this._pattern, this._replacement, this._matchResult, patternEntity, replacementEntity, hostEntity);
                        if (request == null) continue;
                        request.execute();
                    }
                    catch (IllegalActionException e) {
                        throw new TransformationException("Unable to obtain change request.", e);
                    }
                }
            }
            catch (MalformedStringException e) {
                throw new TransformationException("Cannot parse operation list.", e);
            }
        }
    }

    protected void _recordMoML() throws TransformationException {
        this._moml = new HashMap<NamedObj, String>();
        for (Map.Entry entry : this._replacementToHost.entrySet()) {
            NamedObj replacement = (NamedObj)entry.getKey();
            NamedObj host = (NamedObj)entry.getValue();
            String moml = this._getMoML(host);
            this._moml.put(replacement, moml);
        }
    }

    protected void _removeLinks() throws TransformationException {
        this._removeLinks(this._pattern);
    }

    protected void _removeObjects() throws TransformationException {
        this._removeObjects(this._host);
    }

    protected void _wrapup() throws TransformationException {
        this._removeReplacementObjectAttributes(this._host);
        this._removeReplacementObjectAttributes(this._replacement);
    }

    private void _addObjects(NamedObj replacement, NamedObj host) throws TransformationException {
        if (replacement instanceof CompositeEntity) {
            for (Object attributeObject : replacement.attributeList()) {
                Attribute attribute = (Attribute)attributeObject;
                if (!this._isAttributeCopied(attribute)) continue;
                String moml = "<group name=\"auto\">" + attribute.exportMoML() + "</group>";
                MoMLChangeRequest request = new MoMLChangeRequest(this, host, moml);
                request.execute();
            }
        }
        Collection<?> children = GTTools.getChildren(replacement, false, false, true, true);
        for (Object childObject : children) {
            NamedObj child = (NamedObj)childObject;
            NamedObj hostChild = (NamedObj)this._replacementToHost.get(child);
            String moml = null;
            if (hostChild == null) {
                moml = this._getMoML(child);
            } else if (hostChild.getContainer() != host) {
                moml = this._moml.get(child);
            }
            if (moml != null && !moml.equals("")) {
                moml = "<group name=\"auto\">\n" + moml + "</group>";
                MoMLChangeRequest request = new MoMLChangeRequest(this, host, moml);
                request.execute();
                hostChild = this._getNewlyAddedObject(host, child.getClass());
                this._addReplacementToHostEntries(hostChild);
            }
            if (hostChild == null) continue;
            this._addObjects(child, hostChild);
        }
    }

    private void _addReplacementToHostEntries(NamedObj host) {
        ReplacementObjectAttribute attribute = this._getReplacementObjectAttribute(host);
        if (attribute != null) {
            String replacementCode = attribute.getExpression();
            NamedObj replacement = GTTools.getObjectFromCode(replacementCode, this._replacement);
            this._replacementToHost.put(replacement, host);
        }
        Collection<?> children = GTTools.getChildren(host, false, true, true, true);
        for (Object childObject : children) {
            NamedObj child = (NamedObj)childObject;
            this._addReplacementToHostEntries(child);
        }
    }

    private Token _getAttribute(NamedObj container, String name, Class<? extends TransformationAttribute> attributeClass) {
        while (container != null) {
            Attribute attribute;
            if (this._replacementToHost.containsValue(container)) {
                container = this._replacementToHost.getKey(container);
            }
            if ((attribute = container.getAttribute(name)) != null && attributeClass.isInstance(attribute)) {
                Parameter parameter = (Parameter)attribute.attributeList().get(0);
                try {
                    return parameter == null ? null : parameter.getToken();
                }
                catch (IllegalActionException e) {
                    return null;
                }
            }
            container = container.getContainer();
        }
        return null;
    }

    private double[] _getBestLocation(List<?> linkedObjectList) {
        double x = 0.0;
        double y = 0.0;
        int num = 0;
        for (int i = 0; i < linkedObjectList.size(); ++i) {
            Location location;
            NamedObj object = (NamedObj)linkedObjectList.get(i);
            if (object instanceof Port) {
                object = object.getContainer();
            }
            if ((location = (Location)object.getAttribute("_location")) == null) continue;
            double[] coordinate = location.getLocation();
            x += coordinate[0];
            y += coordinate[1];
            ++num;
        }
        if (num == 0) {
            num = 1;
        }
        return new double[]{x / (double)num, y / (double)num};
    }

    private String _getLinkMoML(NamedObj object, Relation relation) {
        String moml = null;
        if (object instanceof Port) {
            NamedObj portContainer = object.getContainer();
            moml = "<link port=\"";
            if (portContainer != relation.getContainer()) {
                moml = moml + portContainer.getName() + ".";
            }
            moml = moml + object.getName() + "\" relation=\"" + relation.getName() + "\"/>";
        } else if (object instanceof Relation) {
            moml = "<link relation1=\"" + object.getName() + "\" relation2=\"" + relation.getName() + "\"/>";
        }
        return moml;
    }

    private String _getMoML(NamedObj host) throws TransformationException {
        if (host instanceof CompositeEntity) {
            try {
                CompositeEntity clone = (CompositeEntity)host.clone();
                clone.removeAllEntities();
                clone.removeAllRelations();
                return clone.exportMoMLPlain();
            }
            catch (CloneNotSupportedException e) {
                throw new TransformationException("Cannot clone composite entity " + host.getFullName() + ".", e);
            }
        }
        return host.exportMoMLPlain();
    }

    private NamedObj _getNewlyAddedObject(NamedObj container, Class<? extends NamedObj> objectClass) {
        List objectList;
        if (Attribute.class.isAssignableFrom(objectClass)) {
            objectList = container.attributeList();
        } else if (Entity.class.isAssignableFrom(objectClass)) {
            objectList = ((CompositeEntity)container).entityList();
        } else if (Port.class.isAssignableFrom(objectClass)) {
            objectList = ((Entity)container).portList();
        } else if (Relation.class.isAssignableFrom(objectClass)) {
            objectList = ((CompositeEntity)container).relationList();
        } else {
            return null;
        }
        int lastIndex = objectList.size() - 1;
        return (NamedObj)objectList.get(lastIndex);
    }

    private ReplacementObjectAttribute _getReplacementObjectAttribute(NamedObj object) {
        Attribute attribute = object.getAttribute("replacementObject");
        if (attribute instanceof ReplacementObjectAttribute) {
            return (ReplacementObjectAttribute)attribute;
        }
        return null;
    }

    private void _hideRelations(CompositeEntity host) {
        boolean relationHiding;
        Token relationHidingAttribute = this._getAttribute(host, "RelationHiding", RelationHidingAttribute.class);
        boolean bl = relationHiding = relationHidingAttribute == null ? true : ((BooleanToken)relationHidingAttribute).booleanValue();
        if (relationHiding) {
            Relation relation;
            Collection<?> relations = GTTools.getChildren(host, false, false, false, true);
            for (Object relationObject : relations) {
                relation = (Relation)relationObject;
                List linkedObjects = relation.linkedObjectsList();
                if (linkedObjects.size() != 1) continue;
                String moml = "<deleteRelation name=\"" + relation.getName() + "\"/>";
                MoMLChangeRequest request = new MoMLChangeRequest(this, relation.getContainer(), moml);
                request.execute();
            }
            relations = GTTools.getChildren(host, false, false, false, true);
            for (Object relationObject : relations) {
                relation = (Relation)relationObject;
                List vertices = relation.attributeList(Vertex.class);
                if (!vertices.isEmpty()) continue;
                List linkedObjects = relation.linkedObjectsList();
                if (linkedObjects.size() == 2) {
                    NamedObj head = (NamedObj)linkedObjects.get(0);
                    NamedObj tail = (NamedObj)linkedObjects.get(1);
                    if (!(head instanceof Relation) && !(tail instanceof Relation)) continue;
                    String moml = "<deleteRelation name=\"" + relation.getName() + "\"/>";
                    MoMLChangeRequest request = new MoMLChangeRequest(this, relation.getContainer(), moml);
                    request.execute();
                    if (tail instanceof Relation) {
                        moml = this._getLinkMoML(head, (Relation)tail);
                        request = new MoMLChangeRequest(this, tail.getContainer(), moml);
                        request.execute();
                        continue;
                    }
                    moml = this._getLinkMoML(tail, (Relation)head);
                    request = new MoMLChangeRequest(this, head.getContainer(), moml);
                    request.execute();
                    continue;
                }
                if (linkedObjects.size() <= 2) continue;
                double[] location = this._getBestLocation(relation.linkedObjectsList());
                String moml = "<group name=\"auto\"><vertex name=\"vertex\" value=\"[" + location[0] + ", " + location[1] + "]\"/>" + "</group>";
                MoMLChangeRequest request = new MoMLChangeRequest(this, relation, moml);
                request.execute();
            }
        }
        for (Object compositeChild : host.entityList(CompositeEntity.class)) {
            this._hideRelations((CompositeEntity)compositeChild);
        }
    }

    private void _initPatternToReplacement(NamedObj replacement) {
        NamedObj pattern = replacement == this._replacement ? this._pattern : GTTools.getCorrespondingPatternObject(replacement);
        if (pattern != null) {
            this._patternToReplacement.put(pattern, replacement);
            if (pattern instanceof Entity && replacement instanceof Entity) {
                Entity patternEntity = pattern;
                Entity replacementEntity = (Entity)replacement;
                List patternPortList = patternEntity.portList();
                List replacementPortList = replacementEntity.portList();
                for (int i = 0; i < patternPortList.size(); ++i) {
                    Port patternPort = (Port)patternPortList.get(i);
                    Port replacementPort = (Port)replacementPortList.get(i);
                    this._patternToReplacement.put(patternPort, replacementPort);
                }
            }
        }
        Collection<?> children = GTTools.getChildren(replacement, false, false, true, true);
        for (Object child : children) {
            this._initPatternToReplacement((NamedObj)child);
        }
    }

    private void _initReplacementObjectAttributes(NamedObj replacement) throws TransformationException {
        this._setReplacementObjectAttribute(replacement, GTTools.getCodeFromObject(replacement, this._replacement));
        Collection<?> children = GTTools.getChildren(replacement, false, true, true, true);
        for (Object childObject : children) {
            NamedObj child = (NamedObj)childObject;
            this._initReplacementObjectAttributes(child);
        }
    }

    private void _initReplacementToHost() throws TransformationException {
        this._replacementToHost = new TwoWayHashMap();
        for (NamedObj pattern : this._patternToReplacement.keySet()) {
            NamedObj replacement = (NamedObj)this._patternToReplacement.get(pattern);
            NamedObj host = (NamedObj)this._matchResult.get(pattern);
            if (host == null) continue;
            this._replacementToHost.put(replacement, host);
            this._setReplacementObjectAttribute(host, GTTools.getCodeFromObject(replacement, this._replacement));
        }
    }

    private boolean _isAttributeCopied(Attribute attribute) {
        if (!attribute.isPersistent() || attribute instanceof TransformationAttribute) {
            return false;
        }
        if (attribute instanceof Director || attribute instanceof Variable || attribute instanceof VisibleAttribute) {
            return true;
        }
        return !attribute.attributeList(Location.class).isEmpty();
    }

    private void _removeLinks(CompositeEntity pattern) {
        Collection<?> relations = GTTools.getChildren(pattern, false, false, false, true);
        HashSet linksToRemove = new HashSet();
        for (Object obj : relations) {
            Relation relation = (Relation)obj;
            Relation replacementRelation = (Relation)this._patternToReplacement.get(relation);
            if (replacementRelation == null) continue;
            List linkedObjectList = relation.linkedObjectsList();
            for (Object linkedObject : linkedObjectList) {
                boolean linkRemoved;
                Object replacementLinkedObject = this._patternToReplacement.get(linkedObject);
                if (replacementLinkedObject == null) continue;
                if (replacementLinkedObject instanceof Port) {
                    linkRemoved = !((Port)replacementLinkedObject).isLinked(replacementRelation);
                } else {
                    boolean bl = linkRemoved = !replacementRelation.linkedObjectsList().contains(replacementLinkedObject);
                }
                if (!linkRemoved) continue;
                linksToRemove.add(new Pair(relation, linkedObject));
            }
        }
        for (Pair pair : linksToRemove) {
            String name;
            Object hostObject;
            Relation hostRelation = (Relation)this._matchResult.get(pair.getFirst());
            if (hostRelation == null || (hostObject = this._matchResult.get(pair.getSecond())) == null) continue;
            if (hostObject instanceof Port) {
                Port port = (Port)hostObject;
                name = port.getContainer().getName() + "." + port.getName();
            } else {
                name = ((Relation)hostObject).getName();
            }
            String moml = "<unlink port=\"" + name + "\" relation=\"" + hostRelation.getName() + "\"/>";
            MoMLChangeRequest request = new MoMLChangeRequest(this, hostRelation.getContainer(), moml);
            request.execute();
        }
        Collection<?> entities = GTTools.getChildren(pattern, false, false, true, false);
        for (Object entityObject : entities) {
            if (!(entityObject instanceof CompositeEntity)) continue;
            this._removeLinks((CompositeEntity)entityObject);
        }
    }

    private Set<NamedObj> _removeObject(NamedObj object, boolean shallowRemoval) throws TransformationException {
        if (shallowRemoval && object instanceof CompositeEntity) {
            CompositeEntity entity = (CompositeEntity)object;
            CompositeEntity container = (CompositeEntity)entity.getContainer();
            TwoWayHashMap<NamedObj, NamedObj> entityMap = new TwoWayHashMap<NamedObj, NamedObj>();
            Collection<?> preservedChildren = GTTools.getChildren(entity, false, false, true, true);
            HashMap portLinks = new HashMap();
            for (Object portObject : entity.portList()) {
                ComponentPort componentPort = (ComponentPort)portObject;
                LinkedList linkedRelations = new LinkedList();
                linkedRelations.addAll(componentPort.linkedRelationList());
                linkedRelations.addAll(componentPort.insideRelationList());
                portLinks.put(componentPort, linkedRelations);
            }
            MoMLChangeRequest request = GTTools.getDeletionChangeRequest(this, object);
            request.execute();
            this._removeReplacementToHostEntries(object);
            for (Object obj : preservedChildren) {
                NamedObj child = (NamedObj)obj;
                String moml = "<group name=\"auto\">\n" + child.exportMoMLPlain() + "</group>";
                request = new MoMLChangeRequest(this, container, moml);
                request.execute();
                NamedObj newlyAddedObject = this._getNewlyAddedObject(container, child.getClass());
                this._addReplacementToHostEntries(newlyAddedObject);
                this._replaceMatchResultEntries(child, newlyAddedObject);
                entityMap.put(child, newlyAddedObject);
            }
            for (Map.Entry entry : portLinks.entrySet()) {
                Port port = (Port)entry.getKey();
                List linkedRelations = (List)entry.getValue();
                int width = 1;
                for (Object relationObject : linkedRelations) {
                    Relation relation = (Relation)relationObject;
                    Parameter widthParameter = (Parameter)relation.getAttribute("width");
                    if (widthParameter == null) continue;
                    try {
                        int thisWidth = ((IntToken)widthParameter.getToken()).intValue();
                        if (thisWidth <= width) continue;
                        width = thisWidth;
                    }
                    catch (IllegalActionException e) {
                        throw new TransformationException("Cannot get width of relation " + relation.getName() + ".", e);
                    }
                }
                String moml = "<group name=\"auto\"><relation name=\"relation\"   class=\"ptolemy.actor.TypedIORelation\"></relation></group>";
                request = new MoMLChangeRequest(this, container, moml);
                request.execute();
                Relation newRelation = (Relation)this._getNewlyAddedObject(container, Relation.class);
                entityMap.put(port, newRelation);
            }
            for (Map.Entry entry : entityMap.entrySet()) {
                NamedObj originalObject = (NamedObj)entry.getKey();
                NamedObj newObject = (NamedObj)entry.getValue();
                if (!(originalObject instanceof Relation) && (!(originalObject instanceof Port) || !(newObject instanceof Relation))) continue;
                List linkedObjectList = originalObject instanceof Relation ? ((Relation)originalObject).linkedObjectsList() : (List)portLinks.get(originalObject);
                Relation relation2 = (Relation)newObject;
                for (Object linkedObject : linkedObjectList) {
                    Port originalPort;
                    Entity linkedEntity;
                    if (linkedObject instanceof Relation) {
                        Relation relation1 = (Relation)entityMap.get(linkedObject);
                        if (relation1 == null) {
                            relation1 = (Relation)linkedObject;
                        }
                        String moml = this._getLinkMoML(relation1, relation2);
                        request = new MoMLChangeRequest(this, container, moml);
                        request.execute();
                        continue;
                    }
                    if (!(linkedObject instanceof Port) || (linkedEntity = (Entity)entityMap.get((originalPort = (Port)linkedObject).getContainer())) == null) continue;
                    Port port1 = linkedEntity.getPort(originalPort.getName());
                    String moml = this._getLinkMoML(port1, relation2);
                    request = new MoMLChangeRequest(this, container, moml);
                    request.execute();
                }
            }
            return entityMap.values();
        }
        MoMLChangeRequest request = GTTools.getDeletionChangeRequest(this, object);
        request.execute();
        return null;
    }

    private void _removeObjects(CompositeEntity host) throws TransformationException {
        NamedObj replacement = this._replacementToHost.getKey(host);
        Collection<Object> children = GTTools.getChildren(host, false, false, true, true);
        HashMap<NamedObj, Boolean> childrenToRemove = new HashMap<NamedObj, Boolean>();
        HashSet<Object> newChildren = new HashSet<Object>();
        while (!children.isEmpty()) {
            NamedObj child;
            childrenToRemove.clear();
            for (Object object : children) {
                Boolean shallowRemoval;
                child = (NamedObj)object;
                NamedObj replacementChild = this._replacementToHost.getKey(child);
                NamedObj patternChild = (NamedObj)this._matchResult.getKey(child);
                if (replacementChild == null && patternChild != null) {
                    shallowRemoval = patternChild instanceof CompositeEntity ? Boolean.TRUE : Boolean.FALSE;
                    childrenToRemove.put(child, shallowRemoval);
                    continue;
                }
                if (replacementChild == null || replacementChild.getContainer() == replacement) continue;
                shallowRemoval = replacementChild instanceof CompositeEntity ? Boolean.TRUE : Boolean.FALSE;
                childrenToRemove.put(child, shallowRemoval);
            }
            newChildren.clear();
            for (Map.Entry entry : childrenToRemove.entrySet()) {
                child = (NamedObj)entry.getKey();
                Set<NamedObj> newlyAddedChildren = this._removeObject(child, (Boolean)entry.getValue());
                if (newlyAddedChildren == null) continue;
                newChildren.addAll(newlyAddedChildren);
            }
            children = newChildren;
        }
        for (Object object : host.entityList(CompositeEntity.class)) {
            this._removeObjects((CompositeEntity)object);
        }
    }

    private void _removeReplacementObjectAttributes(NamedObj object) {
        ReplacementObjectAttribute attribute = this._getReplacementObjectAttribute(object);
        if (attribute != null) {
            try {
                attribute.setContainer(null);
            }
            catch (IllegalActionException e) {
            }
            catch (NameDuplicationException e) {
                // empty catch block
            }
        }
        Collection<?> children = GTTools.getChildren(object, false, true, true, true);
        for (Object childObject : children) {
            NamedObj child = (NamedObj)childObject;
            this._removeReplacementObjectAttributes(child);
        }
    }

    private void _removeReplacementToHostEntries(NamedObj host) {
        ReplacementObjectAttribute attribute = this._getReplacementObjectAttribute(host);
        if (attribute != null) {
            String replacementCode = attribute.getExpression();
            NamedObj replacement = GTTools.getObjectFromCode(replacementCode, this._replacement);
            this._replacementToHost.remove(replacement);
        }
        Collection<?> children = GTTools.getChildren(host, false, true, true, true);
        for (Object childObject : children) {
            NamedObj child = (NamedObj)childObject;
            this._removeReplacementToHostEntries(child);
        }
    }

    private void _replaceMatchResultEntries(NamedObj oldHost, NamedObj newHost) {
        NamedObj pattern = (NamedObj)this._matchResult.getKey(oldHost);
        if (pattern != null) {
            this._matchResult.put(pattern, newHost);
        }
        Collection<?> children = GTTools.getChildren(newHost, false, true, true, true);
        for (Object childObject : children) {
            NamedObj child = (NamedObj)childObject;
            String code = GTTools.getCodeFromObject(child, newHost);
            NamedObj oldChild = GTTools.getObjectFromCode(code, oldHost);
            if (oldChild == null) continue;
            this._replaceMatchResultEntries(oldChild, child);
        }
    }

    private void _setReplacementObjectAttribute(NamedObj object, String replacementObjectCode) throws TransformationException {
        try {
            ReplacementObjectAttribute attribute = this._getReplacementObjectAttribute(object);
            if (attribute == null) {
                attribute = new ReplacementObjectAttribute(object, "replacementObject");
            }
            attribute.setExpression(replacementObjectCode);
        }
        catch (KernelException e) {
            throw new TransformationException("Cannot set replacementObject attributes", e);
        }
    }
}

