/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gt.GTEntity;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.GTIngredientsAttribute;
import ptolemy.actor.gt.GTTools;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.PatternObjectAttribute;
import ptolemy.actor.gt.PortMatcher;
import ptolemy.actor.gt.Replacement;
import ptolemy.actor.gt.TransformationRule;
import ptolemy.actor.gt.ingredients.criteria.Criterion;
import ptolemy.actor.gt.ingredients.criteria.PortCriterion;
import ptolemy.actor.gt.ingredients.criteria.SubclassCriterion;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.KernelRuntimeException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.icon.EditorIcon;

public class GTEntityUtils {
    public static void updateAppearance(final GTEntity entity, GTIngredientsAttribute attribute) {
        Workspace workspace = ((NamedObj)((Object)entity)).workspace();
        try {
            workspace.getWriteAccess();
            HashSet<String> preservedPortNames = new HashSet<String>();
            boolean isIconSet = false;
            int i = 1;
            GTIngredientList list = attribute.getIngredientList();
            for (GTIngredient ingredient : list) {
                Criterion criterion;
                if (ingredient instanceof PortCriterion) {
                    boolean isMultiport;
                    criterion = (PortCriterion)ingredient;
                    String portID = ((PortCriterion)criterion).getPortID(list);
                    preservedPortNames.add(portID);
                    TypedIOPort port = (TypedIOPort)((ComponentEntity)((Object)entity)).getPort(portID);
                    boolean isInput = ((PortCriterion)criterion).isInput();
                    boolean isOutput = ((PortCriterion)criterion).isOutput();
                    boolean bl = isMultiport = !((PortCriterion)criterion).isMultiportEnabled() || ((PortCriterion)criterion).isMultiport();
                    if (port != null) {
                        if (port instanceof PortMatcher) {
                            port.setInput(isInput);
                            port.setOutput(isOutput);
                        } else {
                            MoMLChangeRequest request = new MoMLChangeRequest(entity, (NamedObj)((Object)entity), "<deletePort name=\"" + port.getName() + "\"/>");
                            request.setUndoable(true);
                            request.setMergeWithPreviousUndo(true);
                            request.execute();
                            port = new PortMatcher((PortCriterion)criterion, (ComponentEntity)((Object)entity), portID, isInput, isOutput);
                            port.setPersistent(false);
                        }
                    } else {
                        port = new PortMatcher((PortCriterion)criterion, (ComponentEntity)((Object)entity), portID, isInput, isOutput);
                        port.setPersistent(false);
                    }
                    port.setMultiport(isMultiport);
                } else if (ingredient instanceof SubclassCriterion && !isIconSet) {
                    criterion = (SubclassCriterion)ingredient;
                    final String superclass = ((SubclassCriterion)criterion).getSuperclass();
                    ((NamedObj)((Object)entity)).requestChange(new ChangeRequest(entity, "Deferred load actor icon action."){

                        @Override
                        protected void _execute() throws Exception {
                            GTEntityUtils._loadActorIcon(entity, superclass);
                        }
                    });
                    isIconSet = true;
                }
                ++i;
            }
            if (!isIconSet) {
                ((NamedObj)((Object)entity)).requestChange(new RestoreAppearanceChangeRequest(entity));
            }
            LinkedList portList = new LinkedList(((ComponentEntity)((Object)entity)).portList());
            for (i = 0; i < portList.size(); ++i) {
                Port port = (Port)portList.get(i);
                if (!(port instanceof PortMatcher) || preservedPortNames.contains(port.getName())) continue;
                ((PortMatcher)port)._setPortCriterion(null);
                port.setContainer(null);
            }
        }
        catch (KernelException e) {
            throw new KernelRuntimeException(e, "Cannot update appearance for actor " + entity.getName() + ".");
        }
        finally {
            workspace.doneWriting();
        }
    }

    public static void valueChanged(GTEntity entity, Settable settable) {
        NamedObj correspondingEntity;
        GTIngredientsAttribute criteria = entity.getCriteriaAttribute();
        PatternObjectAttribute patternObject = entity.getPatternObjectAttribute();
        if (settable == criteria) {
            if (GTTools.isInPattern((NamedObj)((Object)entity))) {
                entity.updateAppearance(criteria);
                Pattern pattern = (Pattern)GTTools.getContainingPatternOrReplacement((NamedObj)((Object)entity));
                NamedObj container = pattern.getContainer();
                if (container instanceof TransformationRule) {
                    Replacement replacement = ((TransformationRule)container).getReplacement();
                    replacement.updateEntitiesAppearance(criteria);
                }
            }
        } else if (settable == patternObject && GTTools.isInReplacement((NamedObj)((Object)entity)) && (correspondingEntity = GTTools.getCorrespondingPatternObject((NamedObj)((Object)entity))) != null && correspondingEntity instanceof GTEntity) {
            criteria.setPersistent(false);
            try {
                criteria.setExpression("");
            }
            catch (IllegalActionException e) {
                // empty catch block
            }
            entity.updateAppearance(((GTEntity)((Object)correspondingEntity)).getCriteriaAttribute());
        }
    }

    private static void _loadActorIcon(GTEntity entity, String actorClassName) throws Exception {
        CompositeActor container = new CompositeActor();
        String moml = "<group><entity name=\"NewActor\" class=\"" + actorClassName + "\"/></group>";
        try {
            new MoMLChangeRequest(entity, container, moml).execute();
            new LoadActorIconChangeRequest(entity, container).execute();
        }
        catch (Throwable t) {
            GTEntityUtils._removeEditorIcons(entity);
            GTEntityUtils._setIconDescription(entity, entity.getDefaultIconDescription());
        }
    }

    private static void _removeEditorIcons(GTEntity entity) throws KernelException {
        for (Object editorIconObject : ((NamedObj)((Object)entity)).attributeList(EditorIcon.class)) {
            EditorIcon editorIcon = (EditorIcon)editorIconObject;
            editorIcon.setContainer(null);
        }
    }

    private static void _setIconDescription(GTEntity entity, String iconDescription) {
        String moml = "<property name=\"_iconDescription\" class=\"ptolemy.kernel.util.SingletonConfigurableAttribute\">  <configure>" + iconDescription + "</configure>" + "</property>";
        MoMLChangeRequest request = new MoMLChangeRequest(entity, (NamedObj)((Object)entity), moml);
        request.execute();
    }

    private static class RestoreAppearanceChangeRequest
    extends ChangeRequest {
        private GTEntity _entity;

        @Override
        protected void _execute() throws Exception {
            GTEntityUtils._removeEditorIcons(this._entity);
            GTEntityUtils._setIconDescription(this._entity, this._entity.getDefaultIconDescription());
        }

        RestoreAppearanceChangeRequest(GTEntity entity) {
            super((NamedObj)((Object)entity), "Restore the default appearance.");
            this._entity = entity;
        }
    }

    private static class LoadActorIconChangeRequest
    extends ChangeRequest {
        private CompositeEntity _container;
        private GTEntity _entity;

        public LoadActorIconChangeRequest(GTEntity entity, CompositeEntity container) {
            super(container, "Load the icon of the newly created actor");
            this._entity = entity;
            this._container = container;
        }

        @Override
        protected void _execute() throws Exception {
            block1: {
                ComponentEntity actor = (ComponentEntity)this._container.entityList().get(0);
                GTEntityUtils._removeEditorIcons(this._entity);
                ConfigurableAttribute actorAttribute = (ConfigurableAttribute)actor.getAttribute("_iconDescription");
                String iconDescription = actorAttribute.getConfigureText();
                GTEntityUtils._setIconDescription(this._entity, iconDescription);
                List editorIconList = actor.attributeList(EditorIcon.class);
                Iterator i$ = editorIconList.iterator();
                if (!i$.hasNext()) break block1;
                Object editorIconObject = i$.next();
                EditorIcon editorIcon = (EditorIcon)editorIconObject;
                EditorIcon icon = (EditorIcon)editorIcon.clone(((NamedObj)((Object)this._entity)).workspace());
                icon.setName("_icon");
                EditorIcon oldIcon = (EditorIcon)((NamedObj)((Object)this._entity)).getAttribute("_icon");
                if (oldIcon != null) {
                    oldIcon.setContainer(null);
                }
                icon.setContainer((NamedObj)((Object)this._entity));
            }
        }
    }
}

